% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure-relationships.R
\name{two_measures_relationship}
\alias{two_measures_relationship}
\title{Plot the relationship between two measures and optionally highlight a category}
\usage{
two_measures_relationship(data, measure1, measure2, category = NULL)
}
\arguments{
\item{data}{A data frame or tibble}

\item{measure1, measure2}{Unquoted column names of measures}

\item{category}{Unquoted name of a category (can be factor, character or numeric)}
}
\value{
A ggplot plot object
}
\description{
Plot the relationship between two measures and optionally highlight a category
}
\examples{
\donttest{
two_measures_relationship(ggplot2::diamonds, carat, price)
two_measures_relationship(ggplot2::diamonds, carat, depth)
}
two_measures_relationship(ggplot2::mpg, displ, hwy)
two_measures_relationship(ggplot2::mpg, cty, hwy)
two_measures_relationship(ggplot2::mpg, displ, hwy, class)
}
