% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_cluster_data.R
\name{analyze_time_clusters}
\alias{analyze_time_clusters}
\alias{analyze_time_clusters.time_cluster_data}
\title{Bootstrap analysis of time-clusters.}
\usage{
analyze_time_clusters(data, ...)

\method{analyze_time_clusters}{time_cluster_data}(
  data,
  within_subj,
  samples = 2000,
  formula = NULL,
  shuffle_by = NULL,
  parallel = FALSE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{data}{The output of the \code{make_time_cluster_data} function}

\item{...}{Other args for to selected 'test' function; should be identical to those passed to
\code{make_time_cluster_data} function}

\item{within_subj}{Logical indicating whether to perform within-subjects bootstrap resampling.}

\item{samples}{How many iterations should be performed in the bootstrap resampling procedure?}

\item{formula}{Formula for test. Should be identical to that passed to make_time_cluster_data fxn (if
arg ignored there, can be ignored here)}

\item{shuffle_by}{Along which attribute should the data be resampled? Default is the predictor
column. But if the predictor_column is numeric *and* within-subjects, then observations with the
same predictor value could nevertheless correspond to distinct conditions/categories that
should be shuffled separately. For example, when using vocabulary scores to predict looking
behavior, a participant might get identical vocab scores for verbs and nouns; these are
nevertheless distinct categories that should be re-assigned separately when
bootstrap-resampling data. The 'shuffle_by' argument allows you to specify a column which
indicates these kinds of distinct categories that should be resampled separately--
but it's only needed if you've specified a numeric *and* within-subjects predictor column.}

\item{parallel}{Use foreach for speed boost? By default off. May not work on Windows.}

\item{quiet}{Display progress bar/messages? No progress bar when parallel=TRUE.}
}
\value{
A cluster-analysis object, which can be plotted and summarized to examine which temporal periods
  show a significant effect of the predictor variable
}
\description{
Takes data whose time bins have been clustered by test-statistic (using the \code{make_time_cluster_data}
function) and performs a permutation test (Maris & Oostenveld, 2007). This analysis takes a summed
statistic for each cluster, and compares it to the "null" distribution of sum statistics obtained by
shuffling/resampling the data and extracting the largest cluster from each resample.
}
\section{Methods (by class)}{
\itemize{
\item \code{analyze_time_clusters(time_cluster_data)}: 

}}
\examples{
\dontrun{
data(word_recognition)
data <- make_eyetrackingr_data(word_recognition,
                               participant_column = "ParticipantName",
                               trial_column = "Trial",
                               time_column = "TimeFromTrialOnset",
                               trackloss_column = "TrackLoss",
                               aoi_columns = c('Animate','Inanimate'),
                               treat_non_aoi_looks_as_missing = TRUE )
response_window <- subset_by_window(data, window_start_time = 15500, window_end_time = 21000,
                                    rezero = FALSE)
response_time <- make_time_sequence_data(response_window, time_bin_size = 500, aois = "Animate",
                                         predictor_columns = "Sex")

time_cluster_data <- make_time_cluster_data(data = response_time, predictor_column = "SexM",
                         aoi = "Animate", test = "lmer",
                         threshold = 1.5,
                         formula = LogitAdjusted ~ Sex + (1|Trial) + (1|ParticipantName))
summary(time_cluster_data)
plot(time_cluster_data)

# analyze time clusters in a non-parametric analysis

tc_analysis <- analyze_time_clusters(time_cluster_data, within_subj = FALSE,
                                     samples = 2000)
plot(tc_analysis)
summary(tc_analysis)
}

}
