% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_cluster_data.R
\name{make_time_cluster_data}
\alias{make_time_cluster_data}
\alias{make_time_cluster_data.time_sequence_data}
\title{Make data for cluster analysis.}
\usage{
make_time_cluster_data(data, ...)

\method{make_time_cluster_data}{time_sequence_data}(data, predictor_column,
  aoi = NULL, test, threshold, formula = NULL, quiet = FALSE, ...)
}
\arguments{
\item{data}{The output of the \code{make_time_sequence_data} function}

\item{...}{Any other arguments to be passed to the selected 'test' function (e.g., paired,
var.equal, etc.)}

\item{predictor_column}{The variable whose test statistic you are interested in. Testing the
intercept or interaction terms not currently supported}

\item{aoi}{If this dataframe has multiple AOIs, you must specify which to analyze}

\item{test}{What type of test should be performed in each time bin? Supports
\code{t.test}, \code{wilcox}, \code{lm}, or \code{lmer}.}

\item{threshold}{Value of statistic used in determining significance. Non-directional (two-tailed).}

\item{formula}{What formula should be used for test? Optional (for all but \code{lmer}), if unset
uses \code{Prop ~ [predictor_column]}}

\item{quiet}{Show messages?}
}
\value{
The original data, augmented with information about clusters. Calling summary on this data will
  describe these clusters. The dataset is ready for the \code{\link{analyze_time_clusters}} method.
}
\description{
Takes data that has been summarized into time-bins by \code{make_time_sequence_data()}, finds adjacent time
bins that pass some threshold of significance, and assigns these adjacent bins into groups (clusters).
Output is ready for a cluster permutation-based analyses (Maris & Oostenveld, 2007)
}
\section{Methods (by class)}{
\itemize{
\item \code{time_sequence_data}: Make data for time cluster analysis
}}
\examples{
data(word_recognition)
data <- make_eyetrackingr_data(word_recognition, 
                               participant_column = "ParticipantName",
                               trial_column = "Trial",
                               time_column = "TimeFromTrialOnset",
                               trackloss_column = "TrackLoss",
                               aoi_columns = c('Animate','Inanimate'),
                               treat_non_aoi_looks_as_missing = TRUE )
response_window <- subset_by_window(data, window_start_time = 15500, window_end_time = 21000, 
                                    rezero = FALSE)

# identify clusters in the sequence data using a t-test with
# threshold t-value of 2

# (note: t-tests require a summarized dataset)
response_time <- make_time_sequence_data(response_window, time_bin_size = 500, aois = "Animate", 
                                         predictor_columns = "Sex",
                                         summarize_by = "ParticipantName")
                                         
time_cluster_data <- make_time_cluster_data(data = response_time,
                                            predictor_column = "Sex",
                                            aoi = "Animate",
                                            test = "t.test",
                                            threshold = 2
)

# identify clusters in the sequence data using an lmer() random-effects
# model with a threshold t-value of 1.5.

# random-effects models don't require us to summarize
response_time <- make_time_sequence_data(response_window, time_bin_size = 500, aois = "Animate", 
                                         predictor_columns = "Sex")
   
# but they do require a formula to be specified
time_cluster_data <- make_time_cluster_data(data = response_time,
                           predictor_column = "Sex",
                           aoi = "Animate",
                           test = "lmer",
                           threshold = 1.5,
                           formula = LogitAdjusted ~ Sex + (1|Trial) + (1|ParticipantName)
)
  
}

