% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reveal.R
\name{reveal}
\alias{reveal}
\title{reveal}
\usage{
reveal(x, by = NULL, dec = 1, funs = NULL)
}
\arguments{
\item{x}{data frame, numeric vector, or list of numeric vectors}

\item{by}{character vector with the names of the columns. Can be
several variables!}

\item{dec}{how many decimals are displayed}

\item{funs}{not really meant to be used at the moment - change the
Summarizing functions with a named(!) list of functions}
}
\value{
data frame
}
\description{
Shows commonly used summary statistics
}
\details{
Character vectors (or character columns) will be removed.
}
\examples{
x = y = z = c(rnorm(20), NA)
mylist <- list(x = x, y = y, z = z)
## vectors
reveal(x)
reveal(1:10)
## named or unnamed list
reveal(mylist)
set.seed(42)
mydf <- cbind(group = rep(letters[1:3], 4),
setNames(as.data.frame(replicate(c(rnorm(11), NA), n = 3)), letters[24:26]))
## data frames
reveal(mydf)
## data frames by group
reveal(mydf, by = "group")
}
\seealso{
Other revealer: 
\code{\link{reveal_methods}},
\code{\link{reveal_split}()}
}
\concept{revealer}
