% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radf-autoplot.R
\name{autoplot.radf_obj}
\alias{autoplot.radf_obj}
\alias{autoplot2.radf_obj}
\alias{shade}
\title{Plotting \code{radf} models}
\usage{
\method{autoplot}{radf_obj}(
  object,
  cv = NULL,
  sig_lvl = 95,
  option = c("gsadf", "sadf"),
  min_duration = 0L,
  select_series = NULL,
  nonrejected = FALSE,
  shade_opt = shade(),
  trunc = TRUE,
  include_negative = "DEPRECATED",
  ...
)

\method{autoplot2}{radf_obj}(
  object,
  cv = NULL,
  sig_lvl = 95,
  option = c("gsadf", "sadf"),
  min_duration = 0L,
  select_series = NULL,
  nonrejected = FALSE,
  trunc = TRUE,
  shade_opt = shade(),
  ...
)

shade(
  fill = "grey55",
  fill_negative = fill,
  fill_ongoing = NULL,
  opacity = 0.3,
  ...
)
}
\arguments{
\item{object}{An object of class \code{obj}.}

\item{cv}{An object of class \code{cv}.}

\item{sig_lvl}{Significance level. It could be one of 90, 95 or 99.}

\item{option}{Whether to apply the "gsadf" or "sadf" methodology (default = "gsadf").}

\item{min_duration}{The minimum duration of an explosive period for it to be
reported (default = 0).}

\item{select_series}{A vector of column names or numbers specifying the series to be used in plotting.
Note that the order of the series does not alter the order used in plotting.}

\item{nonrejected}{If TRUE, plot all variables regardless of rejecting the NULL at the 5 percent significance level.}

\item{shade_opt}{Shading options, typically set using \code{shade} function.}

\item{trunc}{Whether to remove the period of the minimum window from the plot (default = TRUE).}

\item{include_negative}{Argument name is deprecated and substituted with \code{nonrejected}.}

\item{...}{Further arguments passed to \code{ggplot2::facet_wrap} and \code{ggplot2::geom_rect} for \code{shade}.}

\item{fill}{The shade color that indicates the exuberance periods with positive signal}

\item{fill_negative}{The shade color that indicates the exuberance periods with positive signal}

\item{fill_ongoing}{The shade color that indicates the exuberance periods that are ongoing
the null hypothesis.}

\item{opacity}{The opacity of the shade color aka alpha.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
}
\description{
\code{autoplot.radf_obj} takes \code{radf_obj} and \code{radf_cv} and returns a faceted ggplot object.
\code{shade} is used as an input to \code{shape_opt}. \code{shade} modifies the
geom_rect layer that demarcates the exuberance periods.
}
\examples{
\donttest{
rsim_data <- radf(sim_data_wdate)

autoplot(rsim_data)

# Modify facet_wrap options through ellipsis
autoplot(rsim_data, scales = "free_y", dir  = "v")

# Modify the shading options
autoplot(rsim_data, shade_opt = shade(fill = "pink", opacity = 0.5))

# Allow for nonrejected series to be plotted
autoplot(rsim_data, nonrejected = TRUE)

# Remove the shading completely (2 ways)
autoplot(rsim_data, shade_opt = NULL)
autoplot(rsim_data, shade_opt = shade(opacity = 0))

# Plot only the series with the shading options
autoplot2(rsim_data)
autoplot2(rsim_data, trunc = FALSE) # keep the minw period

# We will need ggplot2 from here on out
library(ggplot2)

# Change (overwrite) color, size or linetype
autoplot(rsim_data) +
  scale_color_manual(values = c("black", "black")) +
  scale_size_manual(values = c(0.9, 1)) +
  scale_linetype_manual(values = c("solid", "solid"))

# Change names through labeller (first way)
custom_labels <- c("psy1" = "new_name_for_psy1", "psy2" = "new_name_for_psy2")
autoplot(rsim_data, labeller = labeller(.default = label_value, id = as_labeller(custom_labels)))

# Change names through labeller (second way)
custom_labels2 <- series_names(rsim_data)
names(custom_labels2) <- custom_labels2
custom_labels2[c(3,5)] <- c("Evans", "Blanchard")
autoplot(rsim_data, labeller = labeller(id = custom_labels2))

# Or change names before plotting
series_names(rsim_data) <- LETTERS[1:5]
autoplot(rsim_data)

# Change Theme options
autoplot(rsim_data) +
  theme(legend.position = "right")
 }
}
