% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim_blan}
\alias{sim_blan}
\title{Simulation of a Blanchard (1979) bubble process}
\usage{
sim_blan(n, pi = 0.7, sigma = 0.03, r = 0.05, b0 = 0.1, seed = NULL)
}
\arguments{
\item{n}{A positive integer specifying the length of the simulated output series.}

\item{pi}{A positive value in (0, 1) which governs the probability of the bubble continuing to grow.}

\item{sigma}{A positive scalar indicating the standard deviation of the innovations.}

\item{r}{A positive scalar that determines the growth rate of the bubble process.}

\item{b0}{The initial value of the bubble.}

\item{seed}{An object specifying if and how the random number generator (rng)
should be initialized. Either NULL or an integer will be used in a call to
\code{set.seed} before simulation. If set, the value is saved as "seed" attribute
of the returned value. The default, NULL, will not change rng state, and
return .Random.seed as the "seed" attribute. Results are different between
the parallel and non-parallel option, even if they have the same seed.}
}
\value{
A numeric vector of length \code{n}.
}
\description{
Simulation of a Blanchard (1979) rational bubble process.
}
\details{
Blanchard's bubble process has two regimes, which occur with probability \eqn{\pi} and \eqn{1-\pi}.
In the first regime, the bubble grows exponentially, whereas in the second regime, the bubble
collapses to a white noise.

With probability \eqn{\pi}:
\deqn{B_{t+1} = \frac{1+r}{\pi}B_t+\epsilon_{t+1}}{B[t+1]=(1+r)/\pi*B[t]+\epsilon[t+1],}
With probability \eqn{1 - \pi}:
\deqn{B_{t+1} = \epsilon_{t+1}}{B[t+1] = \epsilon[t+1],}

where \code{r} is a positive constant and \eqn{\epsilon \sim iid(0, \sigma^2)}{\epsilon - iid(0, \sigma^2)}.
}
\examples{
sim_blan(n = 100, seed = 123) \%>\%
  autoplot()
}
\references{
Blanchard, O. J. (1979). Speculative bubbles, crashes and rational expectations.
Economics letters, 3(4), 387-389.
}
\seealso{
\code{\link{sim_psy1}}, \code{\link{sim_psy2}}, \code{\link{sim_evans}}
}
