% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bootconf1.R
\name{bootconf1}
\alias{bootconf1}
\title{Confidence bands for the sample univariate extremogram}
\usage{
bootconf1(x, R, l, maxlag, quant, type, par, start = 1, cutoff = 1,
  alpha = 0.05, ...)
}
\arguments{
\item{x}{Univariate time series (a vector).}

\item{R}{Number of bootstrap replications (an integer).}

\item{l}{Mean block size for stationary bootstrap or mean of the geometric distribution
used to generate resampling blocks (an integer that is not longer than the
length of the time series).}

\item{maxlag}{Number of lags to include in the extremogram (an integer).}

\item{quant}{Quantile of the time series to indicate an extreme event (a number between 0 and 1).}

\item{type}{Extremogram type (see function  \code{\link{extremogram1}}).}

\item{par}{If par = 1, the bootstrap replication procedure will be parallelized. If par = 0,
no parallelization will be used.}

\item{start}{The lag that the extremogram plots starts at (an integer not greater than \code{maxlag}, default is 1).}

\item{cutoff}{The cutoff of the y-axis on the plot (a number between 0 and 1, default is 1).}

\item{alpha}{Significance level for the confidence bands (a number between 0 and 1, default is 0.05).}

\item{...}{further arguments: plot and axis names.}
}
\value{
Returns a plot of the confidence bands for the sample univariate extremogram.
}
\description{
The function estimates confidence bands for the sample univariate extremogram
             using the stationary bootstrap.
}
\examples{
# generate a GARCH(1,1) process
omega  = 1
alpha  = 0.1
beta   = 0.6
n      = 1000
quant  = 0.95
type   = 1
maxlag = 70
df     = 3
R      = 10
l      = 30
par    = 0
G = extremogram:::garchsim(omega,alpha,beta,n,df)

extremogram1(G, quant, maxlag, type, 1, 1, 0)
bootconf1(G, R, l, maxlag, quant, type, par, 1, 1, 0.05)
}
\references{
\enumerate{
            \item Davis, R. A., Mikosch, T., & Cribben, I. (2012). Towards estimating extremal
            serial dependence via the bootstrapped extremogram. Journal of Econometrics,170(1),
            142-152.
            \item Davis, R. A., Mikosch, T., & Cribben, I. (2011). Estimating extremal
            dependence in univariate and multivariate time series via the extremogram.arXiv
            preprint arXiv:1107.5592.}
}

