% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageOxygen.R
\name{rburr.dependent}
\alias{rburr.dependent}
\title{Generate Burr dependent data}
\usage{
rburr.dependent(n, a, b, alpha)
}
\arguments{
\item{n}{the number of observations. If length(n) > 1, the length is taken to be the number required.}

\item{a}{a parameter of the function.}

\item{b}{a parameter of the function.}

\item{alpha}{the dependence parameter. It is defined by a single value between 0 and 1. The value 1 corresponds to the full independence. The closer to 0 the value of alpha is, the stronger is the dependence. \eqn{alpha} cannot take the value 0.}
}
\value{
Generates a vector of random deviates. The length of the result is determined by n.
}
\description{
Random generation function for the dependent Burr with a, b two shapes parameters and alpha the dependence parameter.
}
\details{
The description of the dependence is described in \emph{Fawcett and Walshaw (2007)}. The Burr distribution is :
\eqn{
  F(x) = 1 - ( 1 + (x ^ a) ) ^ { - b }, x > 0, a > 0, b > 0
}
where a and b are shapes of the distribution.
}
\examples{
theta <- function(t){
   1/2*(1/10+sin(pi*t))*(11/10-1/2*exp(-64*(t-1/2)^2))
 }
n <- 200
t <- 1:n/n
Theta <- theta(t)
plot(theta)
alpha <- 0.6
Burr.dependent <- rburr.dependent(n, 1/Theta, 1, alpha)


}
\references{
Fawcett, D. and Walshaw, D. (2007). Improved estimation for temporally clustered extremes. Environmetrics, 18.2, 173-188.
}

