% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageOxygen.R
\name{CriticalValue}
\alias{CriticalValue}
\title{Computation of the critical value in the hill.adapt function}
\usage{
CriticalValue(NMC, n, kernel = TruncGauss.kernel, kpar = NULL,
  prob = 0.95, gridlen = 100, initprop = 0.1, r1 = 0.25, r2 = 0.05,
  plot = FALSE)
}
\arguments{
\item{NMC}{the number of Monte-Carlo simulations.}

\item{n}{the sample size.}

\item{kernel}{a kernel function for which the critical value is computed. The available kernel functions are Epanechnikov, Triangular, Truncated Gaussian, Biweight and Rectangular. The truncated gaussian kernel is by default.}

\item{kpar}{a value for the kernel function parameter, with no default value.}

\item{prob}{a vector of type 1 errors.}

\item{gridlen, initprop, r1, r2}{parameters used in the function hill.adapt (see \code{\link{hill.adapt}}).}

\item{plot}{If \code{TRUE}, the empirical cummulative distribution function and the critical values are plotted.}
}
\value{
For the type 1 errors \eqn{prob}, this function returns the critical values.
}
\description{
For a given kernel function, compute the critical value (CritVal) of the test statistic in the hill.adapt function by Monte-Carlo simulations.
}
\examples{
n <- 1000
NMC <- 500
prob <- c(0.99)
\dontrun{ #For computing time purpose
  CriticalValue(NMC, n, TruncGauss.kernel, kpar = c(sigma = 1), prob, gridlen = 100 ,
                initprop = 1/10, r1 = 1/4, r2 = 1/20, plot = TRUE)
}

}
\references{
Durrieu, G. and Grama, I. and Pham, Q. and Tricot, J.- M (2015). Nonparametric adaptive estimator of extreme conditional tail probabilities quantiles. Extremes, 18, 437-478.
}
\seealso{
\code{\link{hill.adapt}}
}

