test_that("dbern", {
  expect_identical(dbern(logical(0), integer(0)), numeric(0))
  expect_identical(dbern(NA, 1), NA_real_)
  expect_identical(dbern(1, NA), NA_real_)
  expect_identical(dbern(1, 1), 1)
  expect_identical(dbern(0, 0), 1)
  expect_identical(dbern(1, 0.5), 0.5)
  expect_equal(dbern(0, 0.5, log = TRUE), -0.69314718)
  expect_identical(dbern(0, 1, log = TRUE), -Inf)
})

test_that("pbern", {
  expect_identical(pbern(logical(0), integer(0)), numeric(0))
  expect_identical(pbern(NA, 1), NA_real_)
  expect_identical(pbern(1, NA), NA_real_)
  expect_identical(pbern(1, 1), 1)
  expect_identical(pbern(0, 0), 1)
  expect_identical(pbern(2, 0.5), 1)
  expect_equal(pbern(0, 0.5, log = TRUE), -0.69314718)
  expect_identical(pbern(0, 1, log = TRUE), -Inf)
  expect_equal(pbern(1, 0.5, lower.tail = FALSE), 0)
  expect_identical(pbern(0, 1, lower.tail = FALSE, log = TRUE), 0)
  expect_equal(pbern(0, 0.5, lower.tail = FALSE, log = TRUE), -0.69314718)
})

test_that("qbern", {
  expect_identical(qbern(logical(0), integer(0)), numeric(0))
  expect_identical(qbern(NA, 1), NA_real_)
  expect_identical(qbern(1, NA), NA_real_)
  expect_identical(qbern(1, 1), 1)
  expect_identical(qbern(0, 0), 0)
  expect_identical(qbern(1, 0.5), 1)
  expect_identical(qbern(0.4, 0.5), 0)
  expect_equal(qbern(0, 0.5, log = TRUE), 1)
  expect_equal(qbern(1, 0.5, lower.tail = FALSE), 0)
  expect_identical(qbern(0, 1, lower.tail = FALSE, log = TRUE), 0)
  expect_equal(qbern(0, 1, lower.tail = FALSE, log = TRUE), 0)
})

test_that("rbern", {
  set.seed(99)
  expect_identical(rbern(logical(0), integer(0)), integer(0))
  expect_identical(rbern(1, 1), 1L)
  expect_identical(rbern(0, 0), integer(0))
  expect_identical(rbern(1, 0.5), 1L)
  expect_equal(rbern(4, 0.5), c(0, 1L, 1L, 1L))
  expect_error(rbern(NA, 1))
})
