% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log-lik.R
\name{log_lik_student}
\alias{log_lik_student}
\title{Student's t Log-Likelihood}
\usage{
log_lik_student(x, mean = 0, sd = 1, theta = 0)
}
\arguments{
\item{x}{A numeric vector of values.}

\item{mean}{A numeric vector of the means.}

\item{sd}{A non-negative numeric vector of the standard deviations.}

\item{theta}{A non-negative numeric vector of the dispersion for the mixture
models (student, gamma-Poisson and beta-binomial).}
}
\value{
An numeric vector of the corresponding log-likelihoods.
}
\description{
Student's t Log-Likelihood
}
\examples{
log_lik_student(c(1, 3.5, 4), mean = 1, sd = 2, theta = 1 / 3)
}
\seealso{
Other log_lik_dist: 
\code{\link{log_lik_bern}()},
\code{\link{log_lik_beta_binom}()},
\code{\link{log_lik_binom}()},
\code{\link{log_lik_gamma}()},
\code{\link{log_lik_gamma_pois}()},
\code{\link{log_lik_gamma_pois_zi}()},
\code{\link{log_lik_lnorm}()},
\code{\link{log_lik_neg_binom}()},
\code{\link{log_lik_norm}()},
\code{\link{log_lik_pois}()},
\code{\link{log_lik_pois_zi}()},
\code{\link{log_lik_skewnorm}()}
}
\concept{log_lik_dist}
