% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bern.R
\name{dbern}
\alias{dbern}
\alias{pbern}
\alias{qbern}
\alias{rbern}
\title{Bernoulli Distribution}
\usage{
dbern(x, prob, log = FALSE)

pbern(q, prob, lower.tail = TRUE, log = FALSE)

qbern(p, prob, lower.tail = TRUE, log = FALSE)

rbern(n, prob)
}
\arguments{
\item{x}{A vector of 0s and 1s.}

\item{prob}{A numeric vector of values between 0 and 1 of the probability of
success.}

\item{log}{A flag specifying whether to return the log-transformed value.}

\item{q}{A vector of quantiles.}

\item{lower.tail}{A flag specifying whether to return the lower or upper tail
of the distribution.}

\item{p}{A vector of probabilities.}

\item{n}{A non-negative whole number of the number of random samples to
generate.}
}
\value{
An numeric vector of the random samples.
}
\description{
Bernoulli Distribution
}
\examples{
dbern(1, 0.5)
pbern(0.75, 0.5)
qbern(0.1, 0.5)
rbern(1, 0.5)
}
\concept{bern}
