test_that("pvalue", {
  expect_identical(pvalue(NA_integer_), NA_real_)
  expect_identical(pvalue(integer(0)), NA_real_)
  expect_equal(pvalue(c(1, NA)), NA_real_)
  expect_equal(pvalue(1), 1 / 2)
  expect_equal(pvalue(c(1, 1)), 1 / 3)
  expect_equal(pvalue(c(1, 1, 1)), 1 / 4)
  expect_identical(pvalue(1:9), 1 / 10)
  expect_identical(pvalue(-(1:9)), 1 / 10)
  expect_equal(pvalue(c(-1, 1, 1)), 3 / 4)
  expect_equal(pvalue(c(-1, 1, 1, 1)), 3 / 5)
  expect_equal(pvalue(c(-1, -1, 1, 1)), 1)
  expect_equal(pvalue(0), 1)
  expect_equal(pvalue(c(0, 0)), 1)
  expect_equal(pvalue(c(0, 0, 0)), 1)
  expect_equal(pvalue(c(rep(-1, 25), rep(1, 1000 - 25))), 51 / 1001)
  expect_equal(pvalue(c(rep(-1, 24), rep(1, 1000 - 24))), 49 / 1001)
  expect_equal(pvalue(c(rep(-1, 25), rep(0, 1000 - 25))), 976 / 1001)
})
