% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta-prime-distribution.R
\name{BetaPrime}
\alias{BetaPrime}
\alias{dbetapr}
\alias{pbetapr}
\alias{qbetapr}
\alias{rbetapr}
\title{Beta prime distribution}
\usage{
dbetapr(x, shape1, shape2, scale = 1, log = FALSE)

pbetapr(q, shape1, shape2, scale = 1, lower.tail = TRUE, log.p = FALSE)

qbetapr(p, shape1, shape2, scale = 1, lower.tail = TRUE, log.p = FALSE)

rbetapr(n, shape1, shape2, scale = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{shape1, shape2}{non-negative parameters.}

\item{scale}{positive valued scale parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density, distribution function, quantile function and random generation
for the beta prime distribution.
}
\details{
If \eqn{X \sim \mathrm{Beta}(\alpha, \beta)}{X ~ Beta(\alpha, \beta)}, then
\eqn{\frac{X}{1-X} \sim \mathrm{BetaPrime}(\alpha, \beta)}{X/(1-X) ~ BetaPrime(\alpha, \beta)}.

Probability density function

\deqn{
f(x) = \frac{(x/\sigma)^{\alpha-1} (1+x/\sigma)^{-\alpha -\beta}}{\mathrm{B}(\alpha,\beta)\sigma}
}{
f(x) = ((x/\sigma)^(\alpha-1) * (1 + x/\sigma)^(-\alpha-\beta)) / (B(\alpha,\beta) * \sigma)
}

Cumulative distribution function

\deqn{
F(x) = I_{\frac{x/\sigma}{1+x/\sigma}}(\alpha, \beta)
}{
F(x) = pbeta((x/\sigma)/(1+(x/\sigma)), \alpha, \beta)
}
}
\examples{

x <- rbetapr(1e5, 5, 3, 2)
hist(x, 350, freq = FALSE, xlim = c(0, 100))
curve(dbetapr(x, 5, 3, 2), 0, 100, col = "red", add = TRUE, n = 500)
hist(pbetapr(x, 5, 3, 2))
plot(ecdf(x), xlim = c(0, 100))
curve(pbetapr(x, 5, 3, 2), 0, 100, col = "red", add = TRUE, n = 500)

}
\seealso{
\code{\link[stats]{Beta}}
}
\concept{
Univariate

Continuous
}
\keyword{distribution}
