% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-uniform-distribution.R
\name{DiscreteUniform}
\alias{DiscreteUniform}
\alias{ddunif}
\alias{pdunif}
\alias{qdunif}
\alias{rdunif}
\title{Discrete uniform distribution}
\usage{
ddunif(x, min, max, log = FALSE)

pdunif(q, min, max, lower.tail = TRUE, log.p = FALSE)

qdunif(p, min, max, lower.tail = TRUE, log.p = FALSE)

rdunif(n, min, max)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{min, max}{lower and upper limits of the distribution. Must be finite.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Probability mass function, distribution function, quantile function and random generation
for the discrete uniform distribution.
}
\details{
If \code{min == max}, then discrete uniform distribution is a degenerate distribution.
}
\examples{

x <- rdunif(1e5, 1, 10) 
xx <- -1:11
plot(prop.table(table(x)), type = "h")
lines(xx, ddunif(xx, 1, 10), col = "red")
hist(pdunif(x, 1, 10))
xx <- seq(-1, 11, by = 0.01)
plot(ecdf(x))
lines(xx, pdunif(xx, 1, 10), col = "red")

}
\keyword{distribution}
