% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dichotomy.R
\name{dichotomy}
\alias{dichotomy}
\alias{dichotomy1}
\alias{dichotomy1_df}
\alias{dichotomy_df}
\alias{dummy}
\alias{dummy_df}
\title{Convert variable (possibly multiple choice question) to matrix of dummy variables.}
\usage{
dichotomy(x, prefix = NULL, keep_unused = FALSE, use_na = TRUE,
  keep_values = NULL, keep_labels = NULL, drop_values = NULL,
  drop_labels = NULL)

dichotomy1(x, prefix = NULL, keep_unused = FALSE, use_na = TRUE,
  keep_values = NULL, keep_labels = NULL, drop_values = NULL,
  drop_labels = NULL)

dichotomy1_df(x, prefix = NULL, keep_unused = FALSE, use_na = TRUE,
  keep_values = NULL, keep_labels = NULL, drop_values = NULL,
  drop_labels = NULL)

dichotomy_df(x, prefix = NULL, keep_unused = FALSE, use_na = TRUE,
  keep_values = NULL, keep_labels = NULL, drop_values = NULL,
  drop_labels = NULL)

dummy(x, prefix = NULL, keep_unused = FALSE, use_na = TRUE,
  keep_values = NULL, keep_labels = NULL, drop_values = NULL,
  drop_labels = NULL)

dummy_df(x, prefix = NULL, keep_unused = FALSE, use_na = TRUE,
  keep_values = NULL, keep_labels = NULL, drop_values = NULL,
  drop_labels = NULL)
}
\arguments{
\item{x}{vector/factor/matrix/data.frame.}

\item{prefix}{character. If it is not NULL it instead of labels will be used prefix+values.}

\item{keep_unused}{Logical. Should we create columns for unused value labels/factor levels.}

\item{use_na}{Logical. Should we use NA for rows with all NA or use 0's instead.}

\item{keep_values}{Numeric/character. Values that should be kept. By default
all values will be kept.}

\item{keep_labels}{Numeric/character. Labels/levels that should be kept. By
default all labels/levels will be kept.}

\item{drop_values}{Numeric/character. Values that should be dropped. By default
all values will be kept. Ignored if keep_values/keep_labels are provided.}

\item{drop_labels}{Numeric/character. Labels/levels that should be dropped. By
default all labels/levels will be kept. Ignored if keep_values/keep_labels are provided.}
}
\value{
matrix or data.frame with 0,1 which column names are value labels or
  values with prefix. If label doesn't exist for particular value then this
  value will be used as column name.
}
\description{
This function converts variable/multiple response variable(matrix/data.frame)
 with category encoding into matrix with dichotomy encoding (0/1) 
suited for most statistical analysis, e. g. clustering, factor analysis, 
linear regression and so on. 
\itemize{ 
\item{\code{dichotomy}}{ returns matrix with 0, 1 and possibly NA.} 
\item{\code{dichotomy1}}{ drops last column in dichotomy matrix. It is useful in many cases
because any column of such matrix usually is linear combinations of other columns.}
\item{\code{dummy}}{ is another shortcut for \code{dichotomy}.}
\item{\code{*_df}}{ are the same functions as \code{dichotomy} etc. but return
data.frame instead of matrix.}
}
}
\examples{
# toy example
# brands - multiple response question
# Which brands do you use during last three months? 
set.seed(123)
brands = t(replicate(20,sample(c(1:5,NA),4,replace = FALSE)))
# score - evaluation of tested product
score = sample(-1:1,20,replace = TRUE)
var_lab(brands) = "Used brands"
val_lab(brands) = make_labels("
                              1 Brand A
                              2 Brand B
                              3 Brand C
                              4 Brand D
                              5 Brand E
                              ")

var_lab(score) = "Evaluation of tested brand"
val_lab(score) = make_labels("
                             -1 Dislike it
                              0 So-so
                              1 Like it    
                             ")

# percentage of used brands
colMeans(dichotomy(brands))

# percentage of brands within each score
cro_mean(dichotomy(brands), score)
# the same as
cro_cpct(brands, score)

# percentage of brands within each score - same numbers
aggregate(dichotomy(brands) ~ f(score), FUN = mean)

# or, same result in another form
by(dichotomy(brands), f(score), FUN = colMeans)

# customer segmentation by used brands
kmeans(dichotomy(brands),3)

# model of influence of used brands on evaluation of tested product 
summary(lm(score ~ dichotomy(brands)))

# prefixed data.frame 
dichotomy_df(brands, prefix = "brand_")

}
\seealso{
\code{\link{category}} for reverse conversion.
}

