% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge.etable}
\alias{merge.etable}
\title{Merge two tables/data.frames}
\usage{
\method{merge}{etable}(
  x,
  y,
  by = 1,
  by.x = by,
  by.y = by,
  all = TRUE,
  all.x = all,
  all.y = all,
  sort = FALSE,
  suffixes = c("", ""),
  incomparables = NULL,
  ...
)
}
\arguments{
\item{x}{data.frame or results of \code{fre}/\code{cross_*}/\code{table_*}}

\item{y}{data.frame or results of \code{fre}/\code{cross_*}/\code{table_*}}

\item{by}{for 'etable' object default is 1 (first column). For details see \link[base]{merge}}

\item{by.x}{For details see \link[base]{merge}}

\item{by.y}{For details see \link[base]{merge}}

\item{all}{For details see \link[base]{merge}}

\item{all.x}{For details see \link[base]{merge}}

\item{all.y}{For details see \link[base]{merge}}

\item{sort}{For details see \link[base]{merge}}

\item{suffixes}{For details see \link[base]{merge}}

\item{incomparables}{For details see \link[base]{merge}}

\item{...}{arguments to be passed to or from methods.}
}
\value{
data.frame
}
\description{
\code{\%merge\%} is infix shortcut for base \link[base]{merge} with 
\code{all.x = TRUE} and  \code{all.y = FALSE} (left join). There is also 
special method for combining results of \code{cross_*} and \code{fre}. For them
\code{all = TRUE} (full join). It allows make complex tables from simple
ones. See examples. Strange result is possible if one or two arguments have
duplicates in first column (column with labels).
}
\examples{
data(mtcars)
# apply labels
mtcars = apply_labels(mtcars,
                mpg = "Miles/(US) gallon",
                cyl = "Number of cylinders",
                disp = "Displacement (cu.in.)",
                hp = "Gross horsepower",
                drat = "Rear axle ratio",
                wt = "Weight (lb/1000)",
                qsec = "1/4 mile time",
                vs = "V/S",
                vs = c("V-engine" = 0, "Straight engine" = 1),
                am = "Transmission (0 = automatic, 1 = manual)",
                am = c(automatic = 0, manual = 1),
                gear = "Number of forward gears",
                carb = "Number of carburetors"
)

# table by 'am'
tab1 = cross_cpct(mtcars, gear, am)
# table with percents
tab2 = cross_cpct(mtcars, gear, vs)

# combine tables
tab1 \%>\% merge(tab2)

# complex tables
# table with counts
counts = cross_cases(mtcars, list(vs, am, gear, carb), list("Count"))
# table with percents
percents = cross_cpct(mtcars, list(vs, am, gear, carb), list("Column, \%"))

# combine tables
counts \%>\% merge(percents)
}
\seealso{
\link{fre}, \link{cross_cpct}, \link{cross_fun}, \link[base]{merge}
}
