% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/where.R
\name{where}
\alias{where}
\alias{.where}
\title{Subset (filter) data.frames/matrices/vectors/lists}
\usage{
where(data, cond)

.where(cond)
}
\arguments{
\item{data}{data.frame/matrix/vector/list to be subsetted}

\item{cond}{logical or numeric expression indicating elements or rows to 
keep: missing values (NA) are taken as FALSE. If \code{data} is data.frame
then \code{cond} will be evaluated in the scope of the \code{data}.}
}
\value{
data.frame/matrix/vector/list which contains just selected rows.
}
\description{
For the data frame \code{cond} will be evaluated in the data.frame's context.
So columns can be referred as variables in the expression (see the examples).
If \code{data} is list then \code{where} will be applied to each element of 
the list. For other types (vector/matrix) there is no non-standard
evaluation. There is a special constant \code{.N} which equals to number of
rows in \code{data} for usage in \code{cond} expression. \code{.where} is
version for working with default dataset. See \link{default_dataset}.
}
\examples{
# leave only 'setosa'
where(iris, Species == "setosa")
# leave only first five rows
where(iris, 1:5)


# example of .N usage. 
set.seed(42)
train = where(iris, sample(.N, 100))
str(train)

set.seed(42)
test = where(iris, -sample(.N, 100))
str(test)

# list example
set.seed(123)
rand_matr = matrix(sample(10, 60, replace = TRUE), ncol = 3)
rand_vec = sample(10, 20, replace = TRUE)
my_list = list(iris, rand_matr, rand_vec)
# two random elements from the each list item
where(my_list, sample(.N, 2))
}
