% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{get_variable_list}
\alias{get_variable_list}
\title{Listing of variable names}
\usage{
get_variable_list(response_vbl, time_vbl, batch_vbl, xform = c("no", "no"))
}
\arguments{
\item{response_vbl}{A character string specifying the response variable name
that must be a column of \code{data}.}

\item{time_vbl}{A character string specifying the time variable name that
must be a column of \code{data}.}

\item{batch_vbl}{A character string specifying the column in \code{data}
with the grouping information (i.e. a factorial variable) for the
differentiation of the observations of the different batches.}

\item{xform}{A vector of two character strings specifying the transformation
of the response and the time variable. The default is \dQuote{no}
transformation, i.e. \code{c("no", "no")}, where the first element
specifies the transformation of the \eqn{x} variable and the second
element the transformation of the \eqn{y} variable. Valid alternatives
for \eqn{x} and/or \eqn{y} variable transformation are \code{"log"}
(natural logarithm), \code{"sqrt"} (square root) and \code{"sq"} (square).}
}
\value{
A list with the variable names. If the data have been transformed,
the list element names of the original variables have the suffix
\code{".orig"}.
}
\description{
The function \code{get_variable_list()} makes a list of the (original) and,
if applicable, the transformed variable names.
}
\details{
The function \code{get_variable_list()} makes a list of the
variable names. If data have been transformed, the list comprises the
original variable name(s) (with suffix .orig in the corresponding list
element names) and the transformed variable name(s).
}
\keyword{internal}
