% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_testthat.R
\name{local_exc_testthat}
\alias{local_exc_testthat}
\alias{local_exc_safe_inla}
\title{Unit test helpers}
\usage{
local_exc_safe_inla(multicore = FALSE, quietly = TRUE, envir = parent.frame())
}
\arguments{
\item{multicore}{logical; if `TRUE`, multiple cores are allowed, and the
INLA `num.threads` option is not checked or altered. Default: `FALSE`, multicore
not allowed (used for examples and unit tests).}

\item{quietly}{logical; if `TRUE`, prints diagnostic messages. A message is
always printed if the INLA `num.threads` option is altered, regardless of the
`quietly` argument. Default: TRUE.}

\item{envir}{environment for exit handlers}
}
\description{
Local helper functions for package unit tests
}
\section{Functions}{
\itemize{
\item \code{local_exc_safe_inla()}: Tests should set num.threads = "1:1" to ensure
within-system repeatability by calling `local_exc_safe_inla()`;
see also [exc_safe_inla()]

}}
\examples{
\dontrun{
local_exc_safe_inla(multicore = FALSE)
}

}
\keyword{internal}
