% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{excursions.variances}
\alias{excursions.variances}
\title{Calculate variances from a sparse precision matrix}
\usage{
excursions.variances(L, Q, max.threads = 0)
}
\arguments{
\item{L}{Cholesky factor of precision matrix.}

\item{Q}{Precision matrix.}

\item{max.threads}{Decides the number of threads the program can use. Set to 0 for using
the maximum number of threads allowed by the system (default).}
}
\value{
A vector with the variances.
}
\description{
\code{excursions.variances} calculates the diagonal of the inverse of a sparse
symmetric positive definite matrix \code{Q}.
}
\details{
The method for calculating the
diagonal requires the Cholesky factor, \code{L}, of \code{Q}, which should be supplied if
available. If \code{Q} is provided, the cholesky factor is
calculated and the variances are then returned in the same ordering as \code{Q}.
If \code{L} is provided, the variances are returned in the same ordering as \code{L},
even if \code{L@invpivot} exists.
}
\examples{
## Create a tridiagonal precision matrix
n = 21
Q = Matrix(toeplitz(c(1, -0.1, rep(0, n-2))))
v2 = excursions.variances(Q=Q,max.threads=2)
## var2 should be the same as:
v1 = diag(solve(Q))
}
\author{
David Bolin \email{davidbolin@gmail.com}
}
