% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelFitModule.R
\name{TestFitSaturated}
\alias{TestFitSaturated}
\title{Model Fit Functions for saturated model}
\usage{
TestFitSaturated(U, Z, ell_A, nparam)
}
\arguments{
\item{U}{U is either a data class of exametrika, or raw data. When raw data is given,
it is converted to the exametrika class with the \link{dataFormat} function.}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{ell_A}{log likelihood of this model}

\item{nparam}{number of parameters for this model}
}
\value{
\describe{
\item{model_log_like}{log likelihood of analysis model}
\item{bench_log_like}{log likelihood of benchmark model}
\item{null_log_like}{log likelihood of null model}
\item{model_Chi_sq}{Chi-Square statistics for analysis model}
\item{null_Chi_sq}{Chi-Square statistics for null model}
\item{model_df}{degrees of freedom of analysis model}
\item{null_df}{degrees of freedom of null model}
\item{NFI}{Normed Fit Index. Lager values closer to 1.0 indicate a better fit.}
\item{RFI}{Relative Fit Index. Lager values closer to 1.0 indicate a better fit.}
\item{IFI}{Incremental Fit Index. Lager values closer to 1.0 indicate a better fit.}
\item{TLI}{Tucker-Lewis Index. Lager values closer to 1.0 indicate a better fit.}
\item{CFI}{Comparative Fit Index. Lager values closer to 1.0 indicate a better fit.}
\item{RMSEA}{Root Mean Square Error of Approximation. Smaller values closer to 0.0 indicate a better fit.}
\item{AIC}{Akaike Information Criterion. A lower value indicates a better fit.}
\item{CAIC}{Consistent AIC.A lower value indicates a better fit.}
\item{BIC}{Bayesian Information Criterion. A lower value indicates a better fit.}
}
}
\description{
A general function that returns the model fit indices.
}
