% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdf_distances.R
\name{KS_distance}
\alias{KS_distance}
\title{Kolmogorov-Smirnov distance}
\usage{
KS_distance(theta, p_theta, q_theta)
}
\arguments{
\item{theta}{a vector of numerics containing values of the RV \eqn{\theta}}

\item{p_theta}{a vector of numerics containing values of the pdf p at locations theta}

\item{q_theta}{a vector of numerics containing values of the pdf q at locations theta}
}
\value{
The Kolmogorov-Smirnov distance between p and q
}
\description{
\code{KS_distance} calculates the Kolmogorov-Smirnov distance between two pdfs.
}
\examples{
theta=seq(from=-5,to=5,by=0.1)
p_theta = dnorm(theta,mean = 0.2,sd = 1)
q_theta = dnorm(theta,mean = 0.25,sd = 0.5)

}
