% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_ewoc.R
\name{ewoc_d1ph}
\alias{ewoc_d1ph}
\title{Escalation With Overdose Control}
\usage{
ewoc_d1ph(formula, theta, alpha, tau, type = c("continuous", "discrete"),
  rho_prior, mtd_prior, shape_prior = NULL, min_dose, max_dose,
  first_dose = NULL, last_dose = NULL, dose_set = NULL,
  max_increment = NULL, distribution = c("exponential", "weibull"),
  rounding = c("down", "nearest"), n_adapt = 5000, burn_in = 1000,
  n_mcmc = 1000, n_thin = 1, n_chains = 1)
}
\arguments{
\item{formula}{an object of class \code{\link[Formula]{Formula}}: a symbolic
description of the model to be fitted with only one regressor term
corresponding to the dose for the right side and a matrix as a response
containing time and status for the left side.}

\item{theta}{a numerical value defining the proportion of expected patients
to experience a medically unacceptable, dose-limiting toxicity (DLT) if
administered the MTD.}

\item{alpha}{a numerical value defining the probability that the dose selected
by EWOC is higher than the MTD.}

\item{tau}{a numerical value defining the period of time for a possible
toxicity be observed.}

\item{type}{a character describing the type of the Maximum Tolerable Dose
(MTD) variable. It can be 'discrete' or 'continuous'.}

\item{rho_prior}{a matrix 1x2 of hyperparameters for the Beta prior
distribution associated with the parameter rho.}

\item{mtd_prior}{a matrix 1x2 of hyperparameters for the Beta prior
distribution associated with the parameter MTD.}

\item{shape_prior}{a matrix 1x2 of hyperparameters for the Gamma prior
distribution associated with the shape parameter r for the Weibull
distribution.
It is only necessary if distribution = 'weibull'.}

\item{min_dose}{a numerical value defining the lower bound of the support of
the MTD.}

\item{max_dose}{a numerical value defining the upper bound of the support of
the MTD.}

\item{first_dose}{a numerical value for the first allowable dose in the trial.
It is only necessary if type = 'continuous'.}

\item{last_dose}{a numerical value for the last allowable dose in the trial.
It is only necessary if type = 'continuous'.}

\item{dose_set}{a numerical vector of allowable doses in the trial. It is only
necessary if type = 'discrete'.}

\item{max_increment}{a numerical value indicating the maximum increment from the current dose to the next dose.}

\item{distribution}{a character establishing the distribution for the time of
events. It can be 'exponential' or 'weibull'.}

\item{rounding}{a character indicating how to round a continuous dose to the
one of elements of the dose set. It can be 'nearest' or 'down'.
It is only necessary if type = 'discrete'.}

\item{n_adapt}{the number of iterations for adaptation.
See \code{\link[rjags]{adapt}} for details.}

\item{burn_in}{the number of iterations before to start monitoring.}

\item{n_mcmc}{the number of iterations to monitor.}

\item{n_thin}{thinning interval for monitors.}

\item{n_chains}{the number of parallel chains for the model.}
}
\value{
\code{next_dose} the next recommend dose.

\code{mtd} the posterior MTD distribution.

\code{rho} the posterior rho_0 distribution.

\code{sample} a list of the MCMC chains distribution.

\code{trial} a list of the trial conditions.
}
\description{
Finding the next dose for a phase I clinical trial based on Escalation
with Overdose Control (EWOC) design considering parametrization for time
to event response and single agent.
}
\examples{
time <- 9
status <- 0
dose <- 30

test <- ewoc_d1ph(cbind(time, status) ~ dose, type = 'discrete',
                 theta = 0.33, alpha = 0.25, tau = 10,
                 min_dose = 30, max_dose = 50,
                 dose_set = seq(30, 50, 5),
                 rho_prior = matrix(1, ncol = 2, nrow = 1),
                 mtd_prior = matrix(1, ncol = 2, nrow = 1),
                 distribution = 'exponential',
                 rounding = 'nearest')
summary(test)
plot(test)

}
\references{
Tighiouart M, Liu Y, Rogatko A. Escalation with overdose control using time to toxicity for cancer phase I clinical trials. PloS one. 2014 Mar 24;9(3):e93070.
}
