% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evmodel.R
\name{get_ev_model}
\alias{get_ev_model}
\title{Get the EV model object of class \code{evmodel}}
\usage{
get_ev_model(
  names,
  months_lst = list(1:12, 1:12),
  wdays_lst = list(1:5, 6:7),
  connection_GMM,
  energy_GMM,
  connection_log,
  energy_log,
  data_tz
)
}
\arguments{
\item{names}{character vector with the given names of each time-cycle model}

\item{months_lst}{list of integer vectors with the corresponding months of the year for each time-cycle model}

\item{wdays_lst}{list of integer vectors with the corresponding days of the week for each model (week start = 1)}

\item{connection_GMM}{list of different connection bivariate GMM obtained from \code{get_connection_models_from_parameters}}

\item{energy_GMM}{list of different energy univariate GMM obtained from \code{get_energy_models_from_parameters}}

\item{connection_log}{logical, true if connection models have logarithmic transformations}

\item{energy_log}{logical, true if energy models have logarithmic transformations}

\item{data_tz}{character, time zone of the original data (necessary to properly simulate new sessions)}
}
\value{
object of class \code{evmodel}
}
\description{
Get the EV model object of class \code{evmodel}
}
\examples{

# For workdays time cycle
workdays_parameters <- dplyr::tibble(
  profile = c("Worktime", "Visit"),
  ratio = c(80, 20),
  start_mean = c(9, 11),
  start_sd = c(1, 4),
  duration_mean = c(8, 4),
  duration_sd = c(0.5, 2),
  energy_mean = c(15, 6),
  energy_sd = c(4, 3)
)

# For weekends time cycle
weekends_parameters <- dplyr::tibble(
  profile = "Visit",
  ratio = 100,
  start_mean = 12,
  start_sd = 4,
  duration_mean = 3,
  duration_sd = 2,
  energy_mean = 4,
  energy_sd = 4
)

connection_GMM <- purrr::map(
  list(Workdays = workdays_parameters, Weekends = weekends_parameters),
  ~ get_connection_models_from_parameters(.x)
)
energy_GMM <- purrr::map(
  list(Workdays = workdays_parameters, Weekends = weekends_parameters),
  ~ get_energy_models_from_parameters(.x)
)

# Get the whole model
ev_model <- get_ev_model(
  names = c("Workdays", "Weekends"),
  months_lst = list(1:12, 1:12),
  wdays_lst = list(1:5, 6:7),
  connection_GMM = connection_GMM,
  energy_GMM = energy_GMM,
  connection_log = FALSE,
  energy_log = FALSE,
  data_tz = "Europe/Amsterdam"
)


}
