% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{print_user_profile_energy_models_table}
\alias{print_user_profile_energy_models_table}
\title{Get LaTeX code for the energy GMM features OF A SINGLE USER PROFILE (mu and sigma)}
\usage{
print_user_profile_energy_models_table(
  user_profile_GMM,
  label,
  caption,
  full_width,
  filename = NULL
)
}
\arguments{
\item{user_profile_GMM}{Gaussian Mixture Models obtained from function \code{get_energy_models}}

\item{label}{character, e.g. "tab:gmm"}

\item{caption}{character, table caption}

\item{full_width}{logical, if true the "*" will be added next to the "table" tag}

\item{filename}{character, file path to write the latex table to. Is must have ".tex" extension.
If it is NULL, then the character string is returned instead of writing a file.}
}
\value{
character, LaTeX code
}
\description{
Get LaTeX code for the energy GMM features OF A SINGLE USER PROFILE (mu and sigma)
}
\examples{
# The package evprof provides example objects of connection and energy
# Gaussian Mixture Models obtained from California's open data set
# (see California article in package website) created with functions
# `get_connection models` and `get_energy models`.

# Get the working days energy models
energy_models <- evprof::california_GMM$workdays$energy_models

# Print energy GMM table
print_user_profile_energy_models_table(
  user_profile_GMM = energy_models$energy_models[[1]], # GMM from user profile 1
  label = "tab:energy-gmm-profile-1",
  caption = "Energy GMM from user profile 1",
  full_width = TRUE
)



}
