% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Rarefaction.R
\name{Rarefaction}
\alias{PlotRarefaction}
\alias{Rarefaction}
\title{Rarefaction analysis via ressampling}
\usage{
Rarefaction(ind.data, ComparisonFunc, ..., iterations = 1000, num.reps = 10,
  correlation = FALSE, ret.dim = NULL, parallel = FALSE)

PlotRarefaction(comparison.list, y.axis = "Statistic")
}
\arguments{
\item{ind.data}{Matrix of residuals or indiviual measurments}

\item{ComparisonFunc}{comparison function}

\item{...}{Aditional arguments passed to ComparisonFunc}

\item{iterations}{Parameter for comparison function. Number of random skewers or number of permutations in mantel.}

\item{num.reps}{number of populations sampled per sample size}

\item{correlation}{If TRUE, correlation matrix is used, else covariance matrix. MantelCor always uses correlation matrix.}

\item{ret.dim}{When using Krzanowski Correlation, number of retained dimensions may be specified}

\item{parallel}{if TRUE computations are done in parallel. Some foreach backend must be registered, like doParallel or doMC.}

\item{comparison.list}{output from rarefaction functions can be used in ploting}

\item{y.axis}{Y axis lable in plot}
}
\value{
returns the mean value of comparisons from samples to original statistic, for all sample sizes.
}
\description{
Calculates the repeatability of a statistic of the data, such as
correlation or covariance matrix, via bootstrap resampling with
varying sample sizes, from 2 to the size of the original data.
}
\details{
Samples of various sizes, with replacement, are taken from the full population, a statistic calculated
and compared to the full population statistic.

A specialized ploting function displays the results in publication quality.

Bootstraping may be misleading with very small sample sizes. Use with caution.
}
\examples{
ind.data <- iris[1:50,1:4]

results.RS <- Rarefaction(ind.data, PCAsimilarity, num.reps = 5, iterations = 100)
results.Mantel <- Rarefaction(ind.data, MatrixCor, correlation = TRUE,
                              num.reps = 5, iterations = 100)
results.KrzCov <- Rarefaction(ind.data, KrzCor, num.reps = 5, iterations = 100)
results.PCA <- Rarefaction(ind.data, PCAsimilarity, num.reps = 5, iterations = 100)

#Multiple threads can be used with some foreach backend library, like doMC or doParallel
#library(doParallel)
##Windows:
#cl <- makeCluster(2)
#registerDoParallel(cl)
##Mac and Linux:
#registerDoParallel(cores = 2)
#results.KrzCov <- Rarefaction(ind.data, KrzCor, num.reps = 5, parallel = TRUE)

#Easy access
library(reshape2)
melt(results.RS)

#Plotting using ggplot2
a <- PlotRarefaction(results.RS, "Random Skewers")
b <- PlotRarefaction(results.Mantel, "Mantel")
c <- PlotRarefaction(results.KrzCov, "KrzCor")
d <- PlotRarefaction(results.PCA, "PCAsimilarity")

library(grid)
grid.newpage()
pushViewport(viewport(layout = grid.layout(2, 2)))
vplayout <- function(x, y) viewport(layout.pos.row = x, layout.pos.col = y)
print(a, vp = vplayout(1, 1))
print(b, vp = vplayout(1, 2))
print(c, vp = vplayout(2, 1))
print(d, vp = vplayout(2, 2))
}
\author{
Diogo Melo, Guilherme Garcia
}
\seealso{
\code{\link{BootstrapRep}}
}
\keyword{bootstap}
\keyword{rarefaction}
\keyword{repeatability}

