% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/KrzProjection.R
\name{KrzProjection}
\alias{KrzProjection}
\alias{KrzProjection.default}
\alias{KrzProjection.list}
\title{Compare matrices via Modified Krzanowski Correlation}
\usage{
KrzProjection(cov.x, cov.y, ...)

\method{KrzProjection}{default}(cov.x, cov.y, ret.dim.1 = NULL,
  ret.dim.2 = NULL, ...)

\method{KrzProjection}{list}(cov.x, cov.y = NULL, ret.dim.1 = NULL,
  ret.dim.2 = NULL, parallel = FALSE, full.results = FALSE, ...)
}
\arguments{
\item{cov.x}{Single covariance matrix ou list of covariance matrices.
If cov.x is a single matrix is suplied, it is compared to cov.y.
If cov.x is a list of matrices is suplied and no cov.y is suplied, all matrices
are compared between each other.
If cov.x is a list of matrices and a single cov.y matrix is suplied, all matrices in list are compared to it.}

\item{cov.y}{First argument is compared to cov.y.
If cov.x is a list, every element in cov.x is projected in cov.y.}

\item{...}{aditional arguments passed to other methods}

\item{ret.dim.1}{number of retained dimensions for first matrix in comparison, default for nxn matrix is n/2-1}

\item{ret.dim.2}{number of retained dimensions for second matrix in comparison, default for nxn matrix is n/2-1}

\item{parallel}{if TRUE computations are done in parallel. Some foreach backend must be registered, like doParallel or doMC.}

\item{full.results}{if FALSE returns only total variance, if TRUE also per PC variance.}
}
\value{
Ratio of projected variance to total variance, and ratio of projected total in each PC
}
\description{
Calculates the modified Krzanowski correlation between matrices,
projecting the variance in each principal  components of the first
matrix in to the ret.dim.2 components of the second matrix.
}
\examples{
c1 <- RandomMatrix(10)
c2 <- RandomMatrix(10)
KrzProjection(c1, c2)

m.list <- RandomMatrix(10, 3)
KrzProjection(m.list)
KrzProjection(m.list, full.results = TRUE)
KrzProjection(m.list, ret.dim.1 = 5, ret.dim.2 = 4)
KrzProjection(m.list, ret.dim.1 = 4, ret.dim.2 = 5)

KrzProjection(m.list, c1)
KrzProjection(m.list, c1, full.results = TRUE)

#Multiple threads can be used with some foreach backend library, like doMC or doParallel
#library(doParallel)
##Windows:
#cl <- makeCluster(2)
#registerDoParallel(cl)
##Mac and Linux:
#registerDoParallel(cores = 2)
#KrzProjection(m.list, parallel = TRUE)
}
\author{
Diogo Melo, Guilherme Garcia
}
\references{
Krzanowski, W. J. (1979). Between-Groups Comparison of Principal
Components. Journal of the American Statistical Association, 74(367),
703. doi:10.2307/2286995
}
\seealso{
\code{\link{RandomSkewers}},\code{\link{MantelCor}}
}
\keyword{Krzanowski}
\keyword{matrixcomparison}
\keyword{matrixcorrelation}

