% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MonteCarloStat.R
\name{MonteCarloStat}
\alias{MonteCarloStat}
\title{Parametric population samples with covariance or correlation matrices}
\usage{
MonteCarloStat(cov.matrix, sample.size, iterations, ComparisonFunc, StatFunc,
  parallel = FALSE)
}
\arguments{
\item{cov.matrix}{Covariance matrix.}

\item{sample.size}{Size of the random populations}

\item{iterations}{Number of random populations}

\item{ComparisonFunc}{Comparison functions for the calculated statistic}

\item{StatFunc}{Function for calculating the statistic}

\item{parallel}{if TRUE computations are done in parallel. Some foreach backend must be registered, like doParallel or doMC.}
}
\value{
returns the mean repeatability, or mean value of comparisons from samples to original statistic.
}
\description{
Using a multivariate normal model, random populations are generated
using the suplied covariance matrix. A statistic is calculated on the
random population and compared to the statistic calculated on the
original matrix.
}
\details{
Since this function uses multivariate normal model to generate populations, only covariance matrices should be used.
}
\examples{
cov.matrix <- RandomMatrix(5, 1, 1, 10)

MonteCarloStat(cov.matrix, sample.size = 30, iterations = 50,
               ComparisonFunc = function(x, y) PCAsimilarity(x, y)[1],
               StatFunc = cov)

#Calculating R2 confidence intervals
r2.dist <- MonteCarloR2(RandomMatrix(10, 1, 1, 10), 30)
quantile(r2.dist)

#Multiple threads can be used with some foreach backend library, like doMC or doParallel
#library(doParallel)
##Windows:
#cl <- makeCluster(2)
#registerDoParallel(cl)
##Mac and Linux:
#registerDoParallel(cores = 2)
#MonteCarloStat(cov.matrix, sample.size = 30, iterations = 100,
#               ComparisonFunc = function(x, y) KrzCor(x, y)[1],
#               StatFunc = cov,
#               parallel = TRUE)
}
\author{
Diogo Melo, Guilherme Garcia
}
\seealso{
\code{\link{BootstrapRep}}, \code{\link{AlphaRep}}
}
\keyword{montecarlo}
\keyword{parametricsampling}
\keyword{repeatability}

