% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.accel.decel.R
\name{sim.accel.decel}
\alias{sim.accel.decel}
\title{Simulate an Unbiased Random Walk with an accelerating or decelerating rate of change through time.}
\usage{
sim.accel.decel(
  ns = 20,
  vs = 0.5,
  r = 0.2,
  vp = 0.2,
  nn = rep(20, ns),
  tt = 0:(ns - 1)
)
}
\arguments{
\item{ns}{number of samples in time-series}

\item{vs}{step variance of the trait}

\item{r}{the parameter controlling the exponential decay (if negative) or increase (if positive) of the rate (vs) through time.}

\item{vp}{phenotypic variance of each sample}

\item{nn}{vector of the number of individuals in each sample (identical sample sizes for all time-series is assumed)}

\item{tt}{vector of sample times (ages}
}
\value{
An evolutionary sequence (time-series) data set (a paleoTS object)
}
\description{
Function to simulate an evolutionary sequence data set according to an Unbiased Random Walk with an accelerating or decelerating rate of change through time.
}
\examples{
##Simulate an unbiased random walk where the rate decelerates through time.
x<-sim.accel.decel(40, r=-0.5)

## Plot the data
plotevoTS(x)
}
\author{
Kjetil Lysne Voje
}
