% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpsdengpd.r
\name{psdengpd}
\alias{psdengpd}
\alias{dpsdengpd}
\alias{ppsdengpd}
\alias{qpsdengpd}
\alias{rpsdengpd}
\alias{dpsdengpd}
\alias{psdengpd}
\alias{ppsdengpd}
\alias{qpsdengpd}
\alias{rpsdengpd}
\alias{ppsdengpd}
\alias{psdengpd}
\alias{dpsdengpd}
\alias{qpsdengpd}
\alias{rpsdengpd}
\alias{qpsdengpd}
\alias{psdengpd}
\alias{dpsdengpd}
\alias{ppsdengpd}
\alias{rpsdengpd}
\alias{rpsdengpd}
\alias{psdengpd}
\alias{dpsdengpd}
\alias{ppsdengpd}
\alias{qpsdengpd}
\title{P-Splines Density Estimate and GPD Tail Extreme Value Mixture Model}
\usage{
dpsdengpd(x, beta = NULL, nbinwidth = NULL, xrange = NULL, nseg = 10,
  degree = 3, u = NULL, sigmau = NULL, xi = 0, phiu = TRUE,
  design.knots = NULL, log = FALSE)

ppsdengpd(q, beta = NULL, nbinwidth = NULL, xrange = NULL, nseg = 10,
  degree = 3, u = NULL, sigmau = NULL, xi = 0, phiu = TRUE,
  design.knots = NULL, lower.tail = TRUE)

qpsdengpd(p, beta = NULL, nbinwidth = NULL, xrange = NULL, nseg = 10,
  degree = 3, u = NULL, sigmau = NULL, xi = 0, phiu = TRUE,
  design.knots = NULL, lower.tail = TRUE)

rpsdengpd(n = 1, beta = NULL, nbinwidth = NULL, xrange = NULL,
  nseg = 10, degree = 3, u = NULL, sigmau = NULL, xi = 0,
  phiu = TRUE, design.knots = NULL)
}
\arguments{
\item{x}{quantiles}

\item{beta}{vector of B-spline coefficients (required)}

\item{nbinwidth}{scaling to convert count frequency into proper density}

\item{xrange}{vector of minimum and maximum of B-spline (support of density)}

\item{nseg}{number of segments between knots}

\item{degree}{degree of B-splines (0 is constant, 1 is linear, etc.)}

\item{u}{threshold}

\item{sigmau}{scale parameter (positive)}

\item{xi}{shape parameter}

\item{phiu}{probability of being above threshold \eqn{[0, 1]} or \code{TRUE}}

\item{design.knots}{spline knots for splineDesign function}

\item{log}{logical, if TRUE then log density}

\item{q}{quantiles}

\item{lower.tail}{logical, if FALSE then upper tail probabilities}

\item{p}{cumulative probabilities}

\item{n}{sample size (positive integer)}
}
\value{
\code{\link[evmix:psdengpd]{dpsdengpd}} gives the density, 
\code{\link[evmix:psdengpd]{ppsdengpd}} gives the cumulative distribution function,
\code{\link[evmix:psdengpd]{qpsdengpd}} gives the quantile function and 
\code{\link[evmix:psdengpd]{rpsdengpd}} gives a random sample.
}
\description{
Density, cumulative distribution function, quantile function and
  random number generation for the extreme value mixture model with P-splines density estimate for bulk
  distribution upto the threshold and conditional GPD above threshold. The parameters
  are the B-spline coefficients \code{beta} (and associated features), threshold \code{u}
  GPD scale \code{sigmau} and shape \code{xi} and tail fraction \code{phiu}.
}
\details{
Extreme value mixture model combining P-splines density estimate for the bulk
below the threshold and GPD for upper tail.

The user can pre-specify \code{phiu} 
permitting a parameterised value for the tail fraction \eqn{\phi_u}. Alternatively, when
\code{phiu=TRUE} the tail fraction is estimated as the tail fraction from the
KDE bulk model.

The cumulative distribution function with tail fraction \eqn{\phi_u} defined by the
upper tail fraction of the P-splines density estimate (\code{phiu=TRUE}), upto the 
threshold \eqn{x \le u}, given by:
\deqn{F(x) = H(x)}
and above the threshold \eqn{x > u}:
\deqn{F(x) = H(u) + [1 - H(u)] G(x)}
where \eqn{H(x)} and \eqn{G(X)} are the P-splines density estimate and conditional GPD
cumulative distribution functions respectively.

The cumulative distribution function for pre-specified \eqn{\phi_u}, upto the
threshold \eqn{x \le u}, is given by:
\deqn{F(x) = (1 - \phi_u) H(x)/H(u)}
and above the threshold \eqn{x > u}:
\deqn{F(x) = \phi_u + [1 - \phi_u] G(x)}
Notice that these definitions are equivalent when \eqn{\phi_u = 1 - H(u)}.

See \code{\link[evmix:gpd]{gpd}} for details of GPD upper tail component. 
The specification of the underlying B-splines and the P-splines density estimator
are discussed in the \code{\link[evmix:psden]{psden}} function help.
}
\note{
Unlike most of the other extreme value mixture model functions the 
\code{\link[evmix:psdengpd]{psdengpd}} functions have not been vectorised as
this is not appropriate. The main inputs (\code{x}, \code{p} or \code{q})
must be either a scalar or a vector, which also define the output length.
The B-splines coefficients \code{beta} and knots \code{design.knots} are vectors.

Default values are provided for P-spline inputs of \code{degree} and \code{nseg} only, 
but all others must be provided by the user. The default sample size for
\code{\link[evmix:psdengpd]{rpsdengpd}} is 1.

Missing (\code{NA}) and Not-a-Number (\code{NaN}) values in \code{x},
\code{p} and \code{q} are passed through as is and infinite values are set to
\code{NA}. None of these are permitted for the parameters/B-spline criteria.

Due to symmetry, the lower tail can be described by GPD by negating the quantiles. 

Error checking of the inputs (e.g. invalid probabilities) is carried out and
will either stop or give warning message as appropriate.
}
\examples{
\dontrun{
set.seed(1)
par(mfrow = c(1, 1))

x = rnorm(1000)
xx = seq(-6, 6, 0.01)
y = dnorm(xx)

# Plenty of histogram bins (100)
breaks = seq(-4, 4, length.out=101)

# P-spline fitting with cubic B-splines, 2nd order penalty and 8 internal segments
# CV search for penalty coefficient. 
fit = fpsdengpd(x, lambdaseq = 10^seq(-5, 5, 0.25), breaks = breaks,
             xrange = c(-4, 4), nseg = 10, degree = 3, ord = 2)
hist(x, freq = FALSE, breaks = seq(-4, 4, length.out=101), xlim = c(-6, 6))

# P-splines only
with(fit, lines(xx, dpsden(xx, beta, nbinwidth, design = design.knots), lwd = 2, col = "blue"))

# P-splines+GPD
with(fit, lines(xx, dpsdengpd(xx, beta, nbinwidth, design = design.knots, 
   u = u, sigmau = sigmau, xi = xi, phiu = phiu), lwd = 2, col = "red"))
abline(v = fit$u, col = "red")

legend("topleft", c("True Density","P-spline density", "P-spline+GPD"),
 col=c("black", "blue", "red"), lty = 1)
}

}
\references{
\url{http://en.wikipedia.org/wiki/B-spline}

\url{http://statweb.lsu.edu/faculty/marx/}

\url{http://en.wikipedia.org/wiki/Generalized_Pareto_distribution}

Scarrott, C.J. and MacDonald, A. (2012). A review of extreme value
threshold estimation and uncertainty quantification. REVSTAT - Statistical
Journal 10(1), 33-59. Available from \url{http://www.ine.pt/revstat/pdf/rs120102.pdf}

Eilers, P.H.C. and Marx, B.D. (1996). Flexible smoothing with B-splines and penalties.
Statistical Science 11(2), 89-121.
}
\seealso{
\code{\link[evmix:psden]{psden}} and \code{\link[evmix:fpsden]{fpsden}}.
}
\author{
Alfadino Akbar and Carl Scarrott \email{carl.scarrott@canterbury.ac.nz}.
}
