% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{simulate.evgam}
\alias{simulate.evgam}
\title{Simulations from a fitted \code{evgam} object}
\usage{
\method{simulate}{evgam}(
  object,
  nsim = 1000,
  seed = NULL,
  newdata,
  type = "link",
  probs = NULL,
  threshold = 0,
  marginal = TRUE,
  ...
)
}
\arguments{
\item{object}{a fitted \code{evgam} object}

\item{nsim}{an integer giving the number of simulations}

\item{seed}{an integer giving the seed for simulations}

\item{newdata}{a data frame}

\item{type}{a character string, as in \code{predict.evgam}; defaults to \code{"quantile"}}

\item{probs}{a scalar or vector of probabilities for quantiles; defaults to NULL}

\item{threshold}{a scalar, vector or matrix, which is added to each simulation if \code{family == "gpd"}; defaults to 0}

\item{marginal}{a logical: should simulations integrate out smoothing parameter uncertainty? Defaults to TRUE}

\item{...}{arguments to be passed to \code{predict.evgam}}
}
\value{
Simulations of parameters or quantiles
}
\description{
Simulations from a fitted \code{evgam} object
}
\examples{

data(fremantle)
fmla_gev <- list(SeaLevel ~ s(Year, k=5, bs="cr"), ~ 1, ~ 1)
m_gev <- evgam(fmla_gev, fremantle, family = "gev")
# simulations of link GEV parameters for fremantle data
simulate(m_gev, nsim=5)
# simulations for Year 1989
y1989 <- data.frame(Year = 1989)
# link GEV parameter simulations
simulate(m_gev, nsim=5, newdata = y1989)
# GEV parameter simulations
simulate(m_gev, nsim=5, newdata = y1989, type = "response")
# 10-year return level simulations
simulate(m_gev, nsim=5, newdata = y1989, type= "quantile", prob = .9)
# 10- and 100-year return level simulations
simulate(m_gev, nsim=5, newdata = y1989, type= "quantile", prob = c(.9, .99))

}
\seealso{
\link{predict.evgam}
}
