% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{plot.evgam}
\alias{plot.evgam}
\title{Plot a fitted \code{evgam} object}
\usage{
\method{plot}{evgam}(
  x,
  given.vals = NULL,
  use.image = FALSE,
  add.map = FALSE,
  map.env = "world",
  ...
)
}
\arguments{
\item{x}{a fitted \code{evgam} object}

\item{given.vals}{a list specifying variables values that are fixed.}

\item{use.image}{logical: should \link[graphics]{image} be used to represent two-dimensional smooths, as opposed to \link[graphics]{contour}? Defaults to \code{FALSE}}

\item{add.map}{logical: should a map outline be added to any two-dimensional smooths using \link[maps]{map}? Defaults to \code{FALSE}}

\item{map.env}{a character string identifying the map to superimpose via \link[maps]{map}; defaults to \code{"world"}}

\item{...}{unused}
}
\value{
Plots representing all one- or two-dimensional smooths
}
\description{
Plot a fitted \code{evgam} object
}
\examples{

\donttest{

library(evgam)
data(COprcp)
COprcp$year <- format(COprcp$date, "\%Y")
COprcp_gev <- aggregate(prcp ~ year + meta_row, COprcp, max)
COprcp_gev <- cbind(COprcp_gev, COprcp_meta[COprcp_gev$meta_row,])
fmla_gev <- list(prcp ~ s(lon, lat, k=30) + s(elev, bs="cr"), ~ s(lon, lat, k=20), ~ 1)
m_gev <- evgam(fmla_gev, data=COprcp_gev, family="gev")
plot(m_gev)

}

}
