% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeObserved.R
\name{summarizeObserved}
\alias{summarizeObserved}
\title{Summarize observed data}
\usage{
summarizeObserved(
  df,
  to_predict = "event only",
  showplot = TRUE,
  by_treatment = FALSE
)
}
\arguments{
\item{df}{The subject-level data, including \code{trialsdt},
\code{usubjid}, \code{randdt}, and \code{cutoffdt} for enrollment
prediction, as well as \code{time}, \code{event} and \code{dropout}
for event prediction, and \code{treatment} coded as 1, 2,
and so on, and \code{treatment_description} for prediction
by treatment group.}

\item{to_predict}{Specifies what to predict: "enrollment only",
"event only", or "enrollment and event". By default, it is set to
"event only".}

\item{showplot}{A Boolean variable to control whether or not to
show the observed data plots. By default, it is set to \code{TRUE}.}

\item{by_treatment}{A Boolean variable to control whether or not to
summarize observed data by treatment group. By default,
it is set to \code{FALSE}.}
}
\value{
A list that includes a range of summary statistics,
data sets, and plots depending on the value of \code{to_predict}.
}
\description{
Provides an overview of the observed data, including
the trial start date, data cutoff date, enrollment duration,
number of subjects enrolled, number of events and dropouts,
number of subjects at risk, cumulative enrollment and event data,
daily enrollment rates, and Kaplan-Meier plots for time to event
and time to dropout.
}
\examples{

observed1 <- summarizeObserved(df = interimData1,
                               to_predict = "enrollment and event")

observed2 <- summarizeObserved(df = interimData2,
                               to_predict = "event only")

}
