% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EkNNclus.R
\name{EkNNclus}
\alias{EkNNclus}
\title{EkNNclus algorithm}
\usage{
EkNNclus(x, D, K, y0, ntrials = 1, q = 0.5, p = 1, disp = TRUE,
  tr = FALSE)
}
\arguments{
\item{x}{n x p data matrix (n instances, p attributes).}

\item{D}{n x n dissimilarity matrix (used only if x is not supplied).}

\item{K}{Number of neighbors.}

\item{y0}{Initial partition (vector of length n, with values in {1,2,...}).}

\item{ntrials}{Number of runs of the algorithm (the best solution is kept).}

\item{q}{Parameter in (0,1). Gamma is set to the inverse of the q-quantile of distances
from the K nearest neighbors (same notation as in the paper).}

\item{p}{Exponent of distances, \eqn{\alpha_{ij} = \phi(d_{ij}^p)}.}

\item{disp}{If TRUE, intermediate results are displayed.}

\item{tr}{If TRUE, a trace of the cost function is returned.}
}
\value{
The credal partition (an object of class \code{"credpart"}). In addition to the
usual attributes, the output credal partition has the following attributes:
\describe{
  \item{trace}{Trace of the algorithm (sequence of values of the cost function).}
  \item{W}{The weight matrix.}
}
}
\description{
\code{EkNNclus} computes hard and credal partitions from dissimilarity or attribute
data using the EkNNclus algorithm.
}
\details{
The number of clusters is not specified. It is influenced by parameters K and q.
(It is advised to start with the default values.) For n not too large (say, until one
thousand), y0 can be defined as the vector (1,2,...,n). For larger values of n, it is
advised to start with a random partition of c clusters, c<n.
}
\examples{
## Clustering of the fourclass dataset
data(fourclass)
n<-nrow(fourclass)
N=2
clus<- EkNNclus(fourclass[,1:2],K=60,y0=(1:n),ntrials=N,q=0.9,p=2,disp=TRUE,tr=TRUE)
## Plot of the partition
plot(clus,X=fourclass[,1:2],y=fourclass$y,Outliers=FALSE)
## Plot of the cost function vs number of iteration
L<-vector(length=N)
for(i in 1:N) L[i]<-dim(clus$trace[clus$trace[,1]==i,])[1]
imax<-which.max(L)
plot(0:(L[imax]-1),-clus$trace[clus$trace[,1]==imax,3],type="l",lty=imax,
xlab="time steps",ylab="energy")
for(i in (1:N)) if(i != imax) lines(0:(L[i]-1),-clus$trace[clus$trace[,1]==i,3],type="l",lty=i)
}
\author{
Thierry Denoeux.
}
\references{
T. Denoeux, O. Kanjanatarakul and S. Sriboonchitta.
 EK-NNclus: a clustering procedure based on the evidential K-nearest neighbor rule.
 Knowledge-Based Systems, Vol. 88, pages 57--69, 2015.
 Available from \url{https://www.hds.utc.fr/~tdenoeux}.
}

