% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut_to_classes.R
\name{cut_to_classes}
\alias{cut_to_classes}
\title{Cuts the Values Column into Classes and Polishes the Labels}
\usage{
cut_to_classes(x, n = 5, style = "equal", manual = FALSE,
  manual_breaks = NULL, decimals = 0, nodata_label = "No data")
}
\arguments{
\item{x}{A numeric vector, eg. \code{values} variable in data returned by  \code{get_eurostat}}

\item{n}{A numeric. number of classes/categories}

\item{style}{Chosen style: one of "fixed", "sd", "equal", "pretty", "quantile", "kmeans", "hclust",
"bclust", "fisher", or "jenks"}

\item{manual}{Logical. If manual breaks are being used}

\item{manual_breaks}{Numeric vector with manual threshold values}

\item{decimals}{Number of decimals to include with labels}

\item{nodata_label}{String. Text label for NA category.}
}
\value{
a factor.
}
\description{
Categorises a numeric vector into automatic or manually defined categories.
and polishes the labels ready for used in mapping with \code{merge_with_geodata} function and ggplot2.
}
\examples{
 \dontrun{
   #lp <- get_eurostat("nama_aux_lp")
   lp <- get_eurostat("nama_10_lp_ulc")
   lp$class <- cut_to_classes(lp$values, n=5, style="equal", decimals=1)
 }
}
\author{
Markus Kainu <markuskainu@gmail.com>
}
