% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eurostat_json.R
\name{get_eurostat_json}
\alias{get_eurostat_json}
\title{Get Data from Eurostat API in JSON}
\usage{
get_eurostat_json(id, filters = NULL, type = c("code", "label", "both"),
  lang = c("en", "fr", "de"), stringsAsFactors = default.stringsAsFactors(),
  ...)
}
\arguments{
\item{id}{A code name for the dataset of interested. See the table of
contents of eurostat datasets for more details.}

\item{filters}{A named list of filters. Names of list objects are Eurostat
variable codes and values are vectors of observation codes. If \code{NULL}
(default) the whole dataset is returned. See details for more on filters
and limitations per query.}

\item{type}{A type of variables, "code" (default), "label" or "both". The
"both" will return a data_frame with named vectors, labels as values and
codes as names.}

\item{lang}{A language used for metadata (en/fr/de).}

\item{stringsAsFactors}{if \code{TRUE} (the default) variables are converted
to factors in original Eurostat order. If \code{FALSE} they are returned as
a character.}

\item{...}{Other arguments passed on to \code{\link[httr]{GET}}. For example
a proxy parameters, see details.
.}
}
\value{
A dataset as a data_frame.
}
\description{
Retrieve data from Eurostat API in JSON format.
}
\details{
Data to retrieve from
  \href{http://ec.europa.eu/eurostat/web/json-and-unicode-web-services}{The
  Eurostat Web Services} can be specified with filters. Normally, it is
  better to use JSON query through \code{\link{get_eurostat}}, than to use
  \code{\link{get_eurostat_json}} directly.
  
  Queries are limited to 50 sub-indicators at a time. A time can be
  filtered with fixed "time" filter or with "sinceTimePeriod" and
  "lastTimePeriod" filters. A \code{sinceTimePeriod = 2000} returns
  observations from 2000 to a last available. A \code{lastTimePeriod = 10}
  returns a 10 last observations.
 
  To use a proxy to connect, a \code{\link[httr]{use_proxy}} can be
  passed to \code{\link[httr]{GET}}. For example 
  \code{get_eurostat_json(id, filters, 
  config = httr::use_proxy(url, port, username, password))}.
}
\examples{
 \dontrun{
   tmp <- get_eurostat_json("cdh_e_fos")
   yy <- get_eurostat_json(id = "nama_gdp_c", filters = list(geo=c("EU28", "FI"),
                                                        unit="EUR_HAB",
                                                        indic_na="B1GM"))
}
}
\author{
Przemyslaw Biecek, Leo Lahti, Janne Huovari and Markus Kainu
  \email{ropengov-forum@googlegroups.com}
  \url{http://github.com/ropengov/eurostat}
}
\keyword{database}
\keyword{utilities}
