% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market.R
\name{etrd_option_chain}
\alias{etrd_option_chain}
\title{Option Chains}
\usage{
etrd_option_chain(
  symbol = "SPY",
  expiryYear = NULL,
  expiryMonth = NULL,
  expiryDay = NULL,
  strikePriceNear = NULL,
  noOfStrikes = NULL,
  includeWeekly = "false",
  skipAdjusted = "true",
  optionCategory = NULL,
  chainType = NULL,
  priceType = NULL,
  output = c("df", "list"),
  access_tokens = NULL,
  etrade_cred = NULL,
  sandbox = FALSE
)
}
\arguments{
\item{symbol}{The market symbol for the instrument}

\item{expiryYear}{Indicates the expiry year corresponding to which the
optionchain needs to be fetched}

\item{expiryMonth}{Indicates the expiry month corresponding to which the
optionchain needs to be fetched}

\item{expiryDay}{Indicates the expiry day corresponding to which the
optionchain needs to be fetched}

\item{strikePriceNear}{The optionchians fetched will have strike price nearer
to this value}

\item{noOfStrikes}{Indicates number of strikes for which the optionchain
needs to be fetched}

\item{includeWeekly}{The include weekly options request. Default: false. Can
also be true}

\item{skipAdjusted}{The skip adjusted request. Default: true. Can also be
false}

\item{optionCategory}{The option category. Default: STANDARD. options
include: STANDARD, ALL, MINI}

\item{chainType}{The type of option chain. Default: CALLPUT. Options include:
CALL, PUT, CALLPUT}

\item{priceType}{The price type. Default: ATNM. Options include ATNM, ALL}

\item{output}{Indicate whether the output should be in the form of a data
frame ('df') or list ('list'). Data frame is returned by default.}

\item{access_tokens}{Access tokens are created using
\code{\link{etrd_auth_access_token}}. This entry is not required because
the output is saved and retrieved from R options automatically.}

\item{etrade_cred}{The output created from
\code{\link{etrd_auth_credentials}} when a valid ETRADE key and secret have
been passed. This entry is not required because the output is saved and
retrieved from R options automatically.}

\item{sandbox}{ETRADE offers a sandbox environment for validating API calls
and responses. If using the sandbox environment, this must be set to TRUE
in each function called throughout etrader. ETRADE states "Sandbox
responses use stored data that's intended to provide typical responses for
basic use cases. So the responses you receive will not contain current
data, and may not exactly match your requests in other ways." Essentially,
the responses will not match the requests entered but successful pull will
indicate whether the entry was valid or not.}
}
\value{
a list or data frame of options chains
}
\description{
Returns a list of option chains for a specific underlying instrument. The
request must specify an instrument, and can include the month the option
expires and to show calls, puts, or both. Values returned include the option
pair count and information about each option pair, including the type, call
count, symbol, product, date, and strike price.
}
\examples{
\dontrun{

# Get SPY Expirations
etrd_option_chain('SPY')

}
}
