% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authenticate.R
\name{etrd_auth_access_token}
\alias{etrd_auth_access_token}
\title{Auth Step 3: Create Access Tokens to use etrader}
\usage{
etrd_auth_access_token(verif_code, etrade_cred = NULL, sandbox = FALSE)
}
\arguments{
\item{verif_code}{a 5 digit alpha numeric code created after successfully
logging into the ETRADE URL generated from
\code{\link{etrd_auth_login_url}}}

\item{etrade_cred}{The output created from
\code{\link{etrd_auth_credentials}} when a valid ETRADE key and secret have
been passed. This entry is not required because the output is saved and
retrieved from R options automatically.}

\item{sandbox}{ETRADE offers a sandbox environment for validating API calls
and responses. If using the sandbox environment, this must be set to TRUE
in each function called throughout etrader. ETRADE states "Sandbox
responses use stored data that's intended to provide typical responses for
basic use cases. So the responses you receive will not contain current
data, and may not exactly match your requests in other ways." Essentially,
the responses will not match the requests entered but successful pull will
indicate whether the entry was valid or not.}
}
\value{
a key and secret oauth access token
}
\description{
Step 3 of ETRADE authentication. Pass the verification code generated after a
successful log into the URL created from \code{\link{etrd_auth_login_url}}.
}
\details{
Authentication into the ETRADE environment requires a three step process: set
ETRADE credentials, generate request tokens to create a login URL, and use
the verification code to create access tokens. The verification code is
generated after successfully logging into the URL that comes from
\code{\link{etrd_auth_login_url}}.

The access tokens expire each day at midnight Eastern Time. The next day Auth
step 1-3 will be required to get new access tokens. If two hours have elapsed
between API calls during a trading day, the access token is inactivated. Use
\code{\link{etrd_auth_manage_token}} to refresh an inactivated access token.
}
\examples{
\dontrun{

# The etrade_cred has been stored into options so does not need to be passed
# After a successful log in, paste the verification code as shown
access_tok = etrd_auth_access_token(verif_code = 'XX123')

}
}
\seealso{
\code{\link{etrd_auth_credentials}} to set the key and secret into
  an oauth app, \code{\link{etrd_auth_login_url}} to generate request tokens
  and create a login URL, \code{\link{etrd_auth_access_token}} to use the
  verification code to create access tokens,
  \code{\link{etrd_auth_manage_token}} to renew or revoke access tokens
}
