% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_calcs.R
\name{pac_compare}
\alias{pac_compare}
\title{Compute the difference in the proportion above a specific cut location}
\usage{
pac_compare(data, formula, cuts, ref_group = NULL)
}
\arguments{
\item{data}{The data frame used for estimation - ideally structured in a tidy 
format.}

\item{formula}{A formula of the type \code{out ~ group} where \code{out} is
the outcome variable and \code{group} is the grouping variable. Note this
variable can include any arbitrary number of groups. Additional variables 
can be included with \code{+} to produce separate estimates by the secondary 
or tertiary variables of interest (e.g., \code{out ~ group + characteristic1 
+ characteristic2}).}

\item{cuts}{Optional vector of cut scores. If supplied, the ECDF will be
guaranteed to include these points. Otherwise, there could be gaps in the 
ECDF at those particular points (used in plotting the cut scores).}

\item{ref_group}{Optional. A character vector or forumla listing the 
reference group levels for each variable on the right hand side of the 
formula, supplied in the same order as the formula. Note that if using the
formula version, levels that are numbers, or include hyphens, spaces, etc., 
should be wrapped in back ticks (e.g., 
\code{ref_group = ~ Active + `Non-FRL`}, or \code{ref_group = ~`8`}). When 
in doubt, it is safest to use the back ticks, as they will not interfere 
with anything if they are not needed. See examples below for more details.}
}
\value{
Tidy data frame of the proportion above the cutoff for 
each (or selected) groups.
}
\description{
Computes the difference in the proportion above the specified \code{cuts} 
for all possible pairwise comparisons of the groups specified by the 
\code{formula}.
}
\examples{
# Compute differences for all pairwise comparisons for each of three cuts
pac_compare(star,
    reading ~ condition, 
		 cuts = c(450, 500, 550)) 
		 
pac_compare(star,
    reading ~ condition + freelunch + race, 
		 cuts = c(450, 500))

pac_compare(star,
    reading ~ condition + freelunch + race, 
		 cuts = c(450, 500),
		 ref_group = ~small + no + white) 
}
\seealso{
[esvis::pac(), esvis::tpac(), esvis::tpac_diff()]
}
