% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_utils.R
\name{pp_calcs}
\alias{pp_calcs}
\title{Produce calculations necessary for \link{pp_plot}.}
\usage{
pp_calcs(formula, data, ref_group = NULL, scheme = "ggplot2")
}
\arguments{
\item{formula}{A formula of the type \code{out ~ group} where \code{out} is
the outcome variable and \code{group} is the grouping variable. Note the
grouping variable must only include only two groups.}

\item{data}{The data frame that the data in the formula come from.}

\item{ref_group}{Optional character vector (of length 1) naming the
reference group to be plotted on the x-axis. Defaults to the highest
scoring group.}

\item{scheme}{What color scheme should the lines follow? Defaults to 
mimic the ggplot2 color scheme. Other options come from the 
\href{https://CRAN.R-project.org/package=viridisLite}{viridisLite}
package, and must be installed first. These are the same options available
in the package: "viridis", "magma", "inferno", and "plasma". These color 
schemes work well for color blindness and print well in black and white.
Alternatively, colors can be supplied manually through a call to \code{col}
(through \code{...}).}
}
\value{
List with appropriate \code{probs}, name of the reference group, data for
the reference group and all other groups, and data for the x/y axes.
}
\description{
Produce calculations necessary for \link{pp_plot}.
}
