% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_walk_fwd.R
\name{walk.fwd}
\alias{walk.fwd}
\title{Stepwise efficient forward selection in decomposable graphical models}
\usage{
\method{walk}{fwd}(x, df, q = 0.5, thres = 5)
}
\arguments{
\item{x}{A \code{fwd} object}

\item{df}{data.frame}

\item{q}{Penalty term in the stopping criterion  (\code{0} = AIC and \code{1} = BIC)}

\item{thres}{A threshold mechanism for choosing between two different ways of calculating the entropy. Can Speed up the procedure with the "correct" value.}
}
\value{
A \code{fwd} object; a subclass of \code{gengraph}) used for forward selection.
}
\description{
Stepwise efficient forward selection in decomposable graphical models
}
\details{
A \code{fwd} object can be created using the \code{gengraph} constructor with \code{type = "fwd"}
}
\examples{

d <- derma[, 10:25]

g <- gengraph(d, type = "fwd")
s <- walk(g, d)
print(s)
plot(s)
adj_lst(s)
adj_mat(s)

}
\references{
\url{https://arxiv.org/abs/1301.2267}, \url{https://doi.org/10.1109/ictai.2004.100}
}
\seealso{
\code{\link{fit_graph}}, \code{\link{walk.bwd}}, \code{\link{gengraph}}
}
