% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-drop.R
\name{updateDropInput}
\alias{updateDropInput}
\title{Change the value of a drop input on the client}
\usage{
updateDropInput(session, inputId, selected = NULL, disabled = NULL)
}
\arguments{
\item{session}{The \code{session} object passed to function given to \code{shinyServer}.}

\item{inputId}{The id of the input object.}

\item{selected}{The initially selected value.}

\item{disabled}{Choices (\code{choicesValues}) to disable.}
}
\description{
Change the value of a drop input on the client
}
\examples{
if (interactive()) {

  library(shiny)
  library(esquisse)

  myChoices <- tagList(
    list(icon("home"), style = "width: 100px;"),
    list(icon("flash"), style = "width: 100px;"),
    list(icon("cogs"), style = "width: 100px;"),
    list(icon("fire"), style = "width: 100px;"),
    list(icon("users"), style = "width: 100px;"),
    list(icon("info"), style = "width: 100px;")
  )


  ui <- fluidPage(
    tags$h2("Update Drop Input"),
    fluidRow(
      column(
        width = 6,
        dropInput(
          inputId = "mydrop",
          choicesNames = myChoices,
          choicesValues = c("home", "flash", "cogs", "fire", "users", "info"),
          dropWidth = "220px"
        ),
        verbatimTextOutput(outputId = "res")
      ),
      column(
        width = 6,
        actionButton("home", "Select home"),
        actionButton("flash", "Select flash"),
        actionButton("cogs", "Select cogs"),
        actionButton("fire", "Select fire"),
        actionButton("users", "Select users"),
        actionButton("info", "Select info"),
        checkboxGroupInput(
          inputId = "disabled",
          label = "Choices to disable",
          choices = c("home", "flash", "cogs", "fire", "users", "info")
        ),
        actionButton("disable", "Disable")
      )
    )
  )

  server <- function(input, output, session) {

    output$res <- renderPrint({
      input$mydrop
    })

    observeEvent(input$home, {
      updateDropInput(session, "mydrop", "home")
    })
    observeEvent(input$flash, {
      updateDropInput(session, "mydrop", "flash")
    })
    observeEvent(input$cogs, {
      updateDropInput(session, "mydrop", "cogs")
    })
    observeEvent(input$fire, {
      updateDropInput(session, "mydrop", "fire")
    })
    observeEvent(input$users, {
      updateDropInput(session, "mydrop", "users")
    })
    observeEvent(input$info, {
      updateDropInput(session, "mydrop", "info")
    })

    observeEvent(input$disable, {
      if (!is.null(input$disabled)) {
        updateDropInput(session, "mydrop", disabled = input$disabled)
      } else {
        updateDropInput(session, "mydrop", disabled = character(0))
      }
    })
  }

  shinyApp(ui, server)

}
}
\seealso{
\code{\link{dropInput}}
}
