% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-colors.R
\name{input-colors}
\alias{input-colors}
\alias{colorPicker}
\alias{palettePicker}
\title{Picker input to select color(s)}
\usage{
colorPicker(inputId, label, choices, selected = NULL,
  textColor = "#000", plainColor = FALSE, multiple = FALSE,
  pickerOpts = list(), width = NULL)

palettePicker(inputId, label, choices, selected = NULL,
  textColor = "#000", plainColor = FALSE, pickerOpts = list(),
  width = NULL)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{choices}{List of values to select from. Values must be valid Hex colors.
If elements of the list are named then that name rather than the value is displayed to the user.}

\item{selected}{The initially selected value (or multiple values if \code{multiple = TRUE}).
If not specified then defaults to the first value for single-select lists and no values for multiple select lists.}

\item{textColor}{Color of the text displayed above colors, can be a vector of the same length ass choices.}

\item{plainColor}{Color the full space of the choice menu.}

\item{multiple}{Is selection of multiple items allowed?}

\item{pickerOpts}{Options for \code{\link[shinyWidgets]{pickerInput}}.}

\item{width}{The width of the input : \code{'auto'}, \code{'fit'}, \code{'100px'}, \code{'75\%'}.}
}
\value{
A select control that can be added to a UI definition.
}
\description{
Select menu to view and choose a color or a palette of colors.
}
\examples{
# colorPicker -----------

if (interactive()) {
  
  library(shiny)
  library(esquisse)
  library(scales)
  
  
  ui <- fluidPage(
    tags$h2("pickerColor examples"),
    fluidRow(
      column(
        width = 3,
        colorPicker(
          inputId = "col1",
          label = "With a vector of colors",
          choices = brewer_pal(palette = "Dark2")(8)
        ),
        verbatimTextOutput("res1")
      ),
      column(
        width = 3,
        colorPicker(
          inputId = "col2",
          label = "Change text color",
          choices = brewer_pal(palette = "Blues")(8), 
          textColor = c("black", "black", "black", "white",
                        "white", "white", "white", "white")
        ),
        verbatimTextOutput("res2")
      ),
      column(
        width = 3,
        colorPicker(
          inputId = "col3",
          label = "With a list of vector of colors",
          choices = list(
            "Blues" = brewer_pal(palette = "Blues")(8),
            "Reds" = brewer_pal(palette = "Reds")(8),
            "Greens" = brewer_pal(palette = "Greens")(8)
          )
        ),
        verbatimTextOutput("res3")
      ),
      column(
        width = 3,
        colorPicker(
          inputId = "col4",
          label = "Plain color",
          choices = brewer_pal(palette = "Paired")(8), 
          plainColor = TRUE, 
          multiple = TRUE
        ),
        verbatimTextOutput("res4")
      )
    )
  )
  
  server <- function(input, output, session) {
    
    output$res1 <- renderPrint(input$col1)
    output$res2 <- renderPrint(input$col2)
    output$res3 <- renderPrint(input$col3)
    output$res4 <- renderPrint(input$col4)
    
  }
  
  shinyApp(ui, server)
  
}
# palettePicker -----------

if (interactive()) {
  
  library(shiny)
  library(esquisse)
  library(scales)
  
  ui <- fluidPage(
    tags$h2("pickerColor examples"),
    
    fluidRow(
      column(
        width = 4,
        palettePicker(
          inputId = "pal1", 
          label = "Select a palette", 
          choices = list(
            "Blues" = brewer_pal(palette = "Blues")(8),
            "Reds" = brewer_pal(palette = "Reds")(8)
          )
        ),
        verbatimTextOutput("res1")
      ),
      column(
        width = 4,
        palettePicker(
          inputId = "pal2", 
          label = "With a list of palette", 
          choices = list(
            "Viridis" = list(
              "viridis" = viridis_pal(option = "viridis")(10),
              "magma" = viridis_pal(option = "magma")(10),
              "inferno" = viridis_pal(option = "inferno")(10),
              "plasma" = viridis_pal(option = "plasma")(10),
              "cividis" = viridis_pal(option = "cividis")(10)
            ),
            "Brewer" = list(
              "Blues" = brewer_pal(palette = "Blues")(8),
              "Reds" = brewer_pal(palette = "Reds")(8),
              "Paired" = brewer_pal(palette = "Paired")(8),
              "Set1" = brewer_pal(palette = "Set1")(8)
            )
          ), 
          textColor = c(
            rep("white", 5), rep("black", 4) 
          )
        ),
        verbatimTextOutput("res2")
      ),
      column(
        width = 4,
        palettePicker(
          inputId = "pal3", 
          label = "With plain colors", 
          choices = list(
            "BrBG" = brewer_pal(palette = "BrBG")(8), 
            "PiYG" = brewer_pal(palette = "PiYG")(8), 
            "PRGn" = brewer_pal(palette = "PRGn")(8), 
            "PuOr" = brewer_pal(palette = "PuOr")(8), 
            "RdBu" = brewer_pal(palette = "RdBu")(8), 
            "RdGy" = brewer_pal(palette = "RdGy")(8), 
            "RdYlBu" = brewer_pal(palette = "RdYlBu")(8), 
            "RdYlGn" = brewer_pal(palette = "RdYlGn")(8), 
            "Spectral" = brewer_pal(palette = "Spectral")(8)
          ), 
          plainColor = TRUE, 
          textColor = "white"
        ),
        verbatimTextOutput("res3")
      )
    )
  )
  
  server <- function(input, output, session) {
    
    output$res1 <- renderPrint(input$pal1)
    output$res2 <- renderPrint(input$pal2)
    output$res3 <- renderPrint(input$pal3)
    
  }
  
  shinyApp(ui, server)
  
}
}
