% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_stalta.R
\name{signal_stalta}
\alias{signal_stalta}
\title{Calculate the short-time-average to long time average ratio}
\usage{
signal_stalta(data, sta, lta, lazy = FALSE)
}
\arguments{
\item{data}{\code{eseis} object, \code{numeric} vector or list of 
objects, data set to be processed.}

\item{sta}{\code{Numeric} value, length of the short time average window
size, in number of samples.}

\item{lta}{\code{Numeric} value, length of the long time average window
size, in number of samples.}

\item{lazy}{\code{Logical} value, option to preprocess data, including 
demeaning, detrending and envelope calculation. Default is \code{FALSE}.}
}
\value{
\code{Numeric} vector or list of vectors, STA-LTA ratio signal.
}
\description{
This function calculates the short-time-average to long time average 
(STA-LTA) ratio of a seismic signal and returns that ratio time series.
}
\examples{

## load example data
data(rockfall)

## calculate STA-LTA ratio
rockfall_stalta <- signal_stalta(data = rockfall_eseis, 
                                 sta = 0.5 * 200, 
                                 lta = 10 * 200, 
                                 lazy = TRUE)

}
\author{
Michael Dietze
}
\keyword{eseis}
