% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fdsn.R
\name{read_fdsn}
\alias{read_fdsn}
\title{Download and import seismic data from an FDSN service provider}
\usage{
read_fdsn(
  start,
  duration,
  station,
  network,
  component = "BHZ",
  url,
  eseis = TRUE,
  ...
)
}
\arguments{
\item{start}{\code{POSIXct} value, start time of the data to import. If
lazy users only submit a text string instead of a POSIXct object, the 
function will try to convert that text string, assuming UTC as time zone.}

\item{duration}{\code{Numeric} value, duration of the data to import,
in seconds.}

\item{station}{\code{Character} vector, optional 3-4-digit FDSN station ID.}

\item{network}{\code{Character} vector, optional 2-digit FDSN network ID.}

\item{component}{\code{Character} vector, seismic component to search for. 
If omitted, the function will look for \code{"BHZ"} by default.}

\item{url}{\code{Chracter} vector, URL of the FDSN data provider. Should be 
of the form \code{"http://service.iris.edu"}, i.e., without further URL 
parts. URLs can be submitted as a vector. If omitted, the function will 
look in the two most comprehensive providers, i.e. 
\code{url = c("http://service.iris.edu", "http://eida-federator.ethz.ch")}. 
See details for further information.}

\item{eseis}{\code{Logical} value, option to read data to an \code{eseis}
object (recommended, see documentation of 
\code{aux_initiateeseis}), default is \code{TRUE}}

\item{\dots}{Additional query arguments sent to the FDSN data provider. See
details for available argument names and conventions.}
}
\value{
An \code{eseis} object or a \code{list} with the time  
(\code{$time}) and \code{$signal} vectors as well as meta information.
}
\description{
The function implements download and import of seismic data from FDSN data
providers via the fdsnws-dataselect service (see 
\url{https://www.fdsn.org/webservices/}). It is basically a wrapper for 
the query approach.
}
\details{
The FDSN (International Federation of Digital Seismograph Networks) 
provides access to a large number of seismic stations worldwide. The data 
are organised by network, station, component and further arguments. In 
order to use the eseis function \code{read_fdsn}, one must know at least 
the former three criteria for the data of interest. A list of networks is 
available here: \url{https://www.fdsn.org/networks/}. The function expects 
the 2-digit network code, the 3- or 4-digit station code, a single seismic 
component ID, and the URL to the data archive. Additional query arguments 
can be added (and must be added to point at a single seismic trace to 
download and import). A complete list of query arguments is available 
here: \url{https://www.fdsn.org/webservices/fdsnws-dataselect-1.1.pdf}.

For each network listed there, one can find the URL that gives access to 
the data (if existing) under "Data Access". Note that the function only 
requires the first URL part, e.g., \url{https://geofon.gfz-potsdam.de}.
}
\examples{

\dontrun{

## read and plot 10 min of data from Ecuador, specifying the component
s <- read_fdsn(start = "2020-05-16 22:42:00",
               duration = 360, 
               station = "IMBA", 
               network = "EC", 
               component = "HHZ")
plot(s)

## read and plot 10 min of data from Germany, specifying the URL
s <- read_fdsn(start = "2017-03-21 04:38:00",
               duration = 360, 
               station = "RGN", 
               network = "GE", 
               url = "http://geofon.gfz-potsdam.de")
plot(s)

}
                     
}
\author{
Michael Dietze
}
\keyword{eseis}
