% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_report.R
\name{write_report}
\alias{write_report}
\title{Create a HTML report for (RLum) objects}
\usage{
write_report(object, file, title = "eseis report", browser = FALSE, css)
}
\arguments{
\item{object, }{\code{eseis} object to be reported on}

\item{file}{\code{Character} value, name of the output file (without
extension)}

\item{title}{\code{Character} value, title of the report}

\item{browser}{\code{Logical} value, optionally open the HTML file in the
default web browser after it has been rendered.}

\item{css}{\code{Character} value, path to a CSS file to change the
default styling of the HTML document.}
}
\value{
HTML and .Rds file.
}
\description{
This function creates a HTML report for a given eseis object, listing its
complete processing history. The report serves both as a convenient way of
browsing through objects and as a proper approach to documenting and saving
scientific data and workflows.
}
\details{
The function heavily lends ideas from the function \code{report_RLum()}
written by Christoph Burow, which is contained in the package
\code{Luminescence}. This function here is a truncated, tailored version
with minimised availabilities.
}
\examples{

\dontrun{
## load example data set
data(rockfall)

## make report for rockfall object
write_report(object = rockfall_eseis, 
             browser = TRUE)
}

}
\author{
Michael Dietze
}
