% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deprecated.R, R/convert_d2f.R
\name{esc_d2f}
\alias{esc_d2f}
\alias{convert_d2f}
\title{Convert effect size d into f}
\usage{
esc_d2f(d, se, v, totaln, info = NULL, study = NULL)

convert_d2f(d, se, v, totaln, info = NULL, study = NULL)
}
\arguments{
\item{d}{The effect size \code{d}.}

\item{se}{The standard error of \code{d}. One of \code{se} or \code{v}
must be specified.}

\item{v}{The variance of \code{d}. One of \code{se} or \code{v} must be
specified.}

\item{totaln}{A vector of total sample size(s).}

\item{info}{String with information on the transformation. Used for the
print-method. Usually, this argument can be ignored}

\item{study}{Optional string with the study name. Using \code{\link{combine_esc}} or
\code{as.data.frame} on \code{esc}-objects will add this as column
in the returned data frame.}
}
\value{
The effect size \code{es}, the standard error \code{se}, the variance
        of the effect size \code{var}, the lower and upper confidence limits
        \code{ci.lo} and \code{ci.hi}, the weight factor \code{w} and the
        total sample size \code{totaln}.
}
\description{
Compute effect size \code{f} from effect size \code{d}.
}
\examples{
# d to f
convert_d2f(d = 0.2, se = .1, totaln = 50)

}
\references{
Cohen J. 1988. Statistical Power Analysis for the Behavioral Sciences. 2nd ed. Hillsdale, NJ: Erlbaum
}
