% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{validators}
\alias{validators}
\alias{check_type}
\alias{check_types}
\alias{check_class}
\alias{check_classes}
\alias{check_length}
\alias{check_content}
\alias{check_string}
\alias{check_n}
\alias{check_bool}
\title{Functions for Checking Arguments}
\usage{
check_type(
  x,
  valid,
  name = NULL,
  general = NULL,
  specifics = NULL,
  supplement = NULL,
  ...
)

check_types(x, valid, name = NULL, general = NULL, supplement = NULL, ...)

check_class(
  x,
  valid,
  name = NULL,
  general = NULL,
  specifics = NULL,
  supplement = NULL,
  ...
)

check_classes(x, valid, name = NULL, general = NULL, supplement = NULL, ...)

check_length(
  x,
  valid,
  interval = NULL,
  name = NULL,
  general = NULL,
  specifics = NULL,
  supplement = NULL,
  ...
)

check_content(
  x,
  valid,
  name = NULL,
  general = NULL,
  specifics = NULL,
  supplement = NULL,
  ...
)

check_string(
  x,
  name = NULL,
  general = NULL,
  specifics = NULL,
  supplement = NULL,
  ...
)

check_n(
  x,
  name = NULL,
  general = NULL,
  specifics = NULL,
  supplement = NULL,
  ...
)

check_bool(
  x,
  name = NULL,
  general = NULL,
  specifics = NULL,
  supplement = NULL,
  ...
)
}
\arguments{
\item{x}{The argument to be checked.
\itemize{
\item In \code{\link[=check_types]{check_types()}} and \code{\link[=check_classes]{check_classes()}}, \code{x} must be a list.
\item In other functions, \code{x} can be any object.
}}

\item{valid}{\itemize{
\item In \code{\link[=check_type]{check_type()}} and \code{\link[=check_types]{check_types()}}: a character vector which
contains the valid types.
\item In \code{\link[=check_class]{check_class()}} and \code{\link[=check_classes]{check_classes()}}: a character vector which
contains the valid classes.
\item In \code{\link[=check_length]{check_length()}}: a numeric vector which contains non-negative
integers or \code{NA}, used with argument \code{interval} to indicate the valid
lengths. See argument \code{interval} for more details.
\item In \code{\link[=check_content]{check_content()}}: an atomic vector which contains the valid choices.
}}

\item{name}{Optional. A single character which represents the argument's
name. The name is used in the error message. By default, the name of the
argument passed to argument \code{x} is captured automatically.}

\item{general}{Optional. A single character which represents the general
statement of the error. Each validator function comes with its own
error message, so usually you don't need to specify this argument and
arguments \code{specifics} and \code{supplement}.}

\item{specifics}{Optional. A (named) character vector which represents
details of the error.}

\item{supplement}{Optional. A single character which represents the
additional message added at the end of the error message.}

\item{...}{Optional. Additional arguments passed to \code{\link[rlang:abort]{rlang::abort()}},
which is called internally.}

\item{interval}{Only used in \code{\link[=check_length]{check_length()}}. Optional. \code{TRUE} or
\code{FALSE} which indicates if argument \code{valid} is interpreted as an
interval or as single lengths. For example, \code{c(1, 10)} is interpreted
as "larger than 1 and smaller than 10" if \code{interval} is \code{TRUE},
but as "1 or 10" if \code{FALSE}. \code{NA} can be used in \code{valid} when treated
as interval. For example, \code{c(0, NA)} means "larger than 0". By default,
\code{interval} is inferred automatically.}
}
\value{
An invisible \code{NULL} if the argument is valid,
or error message is generated.
}
\description{
When creating functions for other people to use, you always
need some validator functions which check if arguments passed by users are
valid, and if not, generate informative and good-formatted error messages
in a consistent style.

Functions documented here serve the exact purposes:
\itemize{
\item \code{\link[=check_type]{check_type()}} checks if an argument has valid type.
\item \code{\link[=check_types]{check_types()}} checks if each item of an argument has valid type.
\item \code{\link[=check_class]{check_class()}} checks if an argument has valid class.
\item \code{\link[=check_classes]{check_classes()}} checks if each item of an argument has valid class.
\item \code{\link[=check_length]{check_length()}} checks if an argument has valid length.
\item \code{\link[=check_content]{check_content()}} checks if an argument is from some given choices.
\item \code{\link[=check_string]{check_string()}} checks if an argument is a single character.
It can be used to check names, for example.
\item \code{\link[=check_n]{check_n()}} checks if an argument is a single positive integer.
It can be used to check indices, for example.
\item \code{\link[=check_bool]{check_bool()}} checks if an argument is \code{TRUE} or \code{FALSE}.
}
}
\examples{
# argument to be checked
arg <- 1:10

# invisible `NULL` returned if `arg` is valid
check_type(arg, "integer")

\dontrun{
# check if `arg` is character or double
check_type(arg, c("character", "double"))

# check if `arg` has length 1
check_length(arg, 1)

# check if `arg` has length smaller than 3
check_length(arg, c(NA, 3))

# specify argument's name
check_type(arg, "character", "`other_name`")

# customize error message
check_type(
  arg,
  "character",
  general = "General statement of the error.",
  specifics = c(x = "An error.", i = "A hint.", `*` = "Other detail."),
  supplement = "More words to say."
)
}

# add and retrieve additional arguments
tryCatch(
  {check_type(arg, "character", your_arg = "your data")},
  error = function(e) e$your_arg
)
}
\seealso{
\code{\link[=Statement]{Statement()}} for more details about arguments \code{general},
\code{specifics} and \code{supplement}.

\code{\link[rlang:abort]{rlang::abort()}} for adding additional arguments.

\code{vignette("erify", package = "erify")} for a gentle introduction to this
package.

\href{https://style.tidyverse.org/error-messages.html}{The tidyverse style guide}
for more details about the used error message style.
}
