% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R, R/InitWtErgmTerm.R
\name{edgecov-ergmTerm}
\alias{edgecov-ergmTerm}
\alias{InitErgmTerm.edgecov}
\alias{InitWtErgmTerm.edgecov}
\title{Edge covariate}
\usage{
# binary: edgecov(x, attrname=NULL)

# valued: edgecov(x, attrname=NULL, form="sum")
}
\arguments{
\item{x, attrname}{a specification for the dyadic covariate: either
one of the following, or the name of a network attribute
containing one of the following: \describe{

\item{a covariate matrix}{with dimensions \eqn{n \times n}{n*n}
for unipartite networks and \eqn{b \times (n-b)}{b*(n-b)} for
bipartite networks; \code{attrname}, if given, is used to construct
the term name.}

\item{a network object}{with the same size and bipartitedness as
LHS; \code{attrname}, if given, provides the name of the
quantitative edge attribute to use for covariate values (in
this case, missing edges in \code{x} are assigned a covariate value
of zero).}

}}

\item{form}{character how to aggregate tie values in a valued ERGM}
}
\description{
This term adds one statistic to the model, equal to the sum
of the covariate values for each edge appearing in the network. The
\code{edgecov} term applies to both directed and undirected networks. For
undirected networks the covariates are also assumed to be undirected. The
\code{edgecov} and \code{dyadcov} terms are equivalent for undirected
networks.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "edgecov", "subsection")}
}
\concept{directed}
\concept{dyad-independent}
\concept{frequently-used}
\concept{quantitative dyadic attribute}
\concept{undirected}
